/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.font;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.font.EmojiMetadata;
import org.figuramc.figura.font.EmojiUnicodeLookup;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.JsonUtils;
import org.figuramc.figura.utils.TextUtils;

public class EmojiContainer {
    public static final String JSON_KEY_FRAMES = "frames";
    public static final String JSON_KEY_FRAME_TIME = "frametime";
    public static final String JSON_KEY_WIDTH = "width";
    public static final String JSON_KEY_NAMES = "names";
    public static final String JSON_KEY_SHORTCUTS = "shortcuts";
    private static final String ERROR_MSG = "Invalid emoji metadata \"{}\" @ \"{}\", Reason: Field '{}' {}";
    private static final class_2583 STYLE = class_2583.field_24360.method_10977(class_124.field_1068);
    public final String name;
    private final class_2960 font;
    private final EmojiUnicodeLookup lookup = new EmojiUnicodeLookup();
    private final String blacklist;

    public EmojiContainer(String containerName, JsonObject data) {
        this.name = containerName;
        this.font = new FiguraIdentifier("emoji_" + containerName);
        this.blacklist = data.get("blacklist").getAsString();
        for (Map.Entry emoji : data.get("emojis").getAsJsonObject().entrySet()) {
            String[] arr;
            ArrayList validAliases;
            String curUnicode = (String)emoji.getKey();
            JsonElement curValue = (JsonElement)emoji.getValue();
            JsonArray namesArray = null;
            JsonArray shortcutsArray = null;
            if (curValue.isJsonArray()) {
                namesArray = curValue.getAsJsonArray();
            } else {
                JsonObject obj = curValue.getAsJsonObject();
                if (JsonUtils.validate(obj, JSON_KEY_NAMES, JsonElement::isJsonArray, ERROR_MSG, curUnicode.codePointAt(0), containerName, JSON_KEY_NAMES, "must be an array")) {
                    namesArray = obj.getAsJsonArray(JSON_KEY_NAMES);
                }
                if ((obj.has(JSON_KEY_FRAME_TIME) || obj.has(JSON_KEY_FRAME_TIME)) && JsonUtils.validate(obj, JSON_KEY_FRAMES, JsonElement::isJsonPrimitive, ERROR_MSG, curUnicode.codePointAt(0), containerName, JSON_KEY_FRAMES, "field must be an int") && JsonUtils.validate(obj, JSON_KEY_FRAME_TIME, JsonElement::isJsonPrimitive, ERROR_MSG, curUnicode.codePointAt(0), containerName, JSON_KEY_FRAME_TIME, "field must be an int")) {
                    this.lookup.putMetadata(curUnicode.codePointAt(0), new EmojiMetadata(obj));
                }
                if (obj.has(JSON_KEY_SHORTCUTS) && JsonUtils.validate(obj, JSON_KEY_SHORTCUTS, JsonElement::isJsonArray, ERROR_MSG, curUnicode.codePointAt(0), containerName, JSON_KEY_SHORTCUTS, "field must be an array")) {
                    shortcutsArray = obj.getAsJsonArray(JSON_KEY_SHORTCUTS);
                }
            }
            if (namesArray != null) {
                validAliases = new ArrayList();
                if (EmojiContainer.validateAliases(containerName, namesArray, validAliases::add)) {
                    arr = new String[validAliases.size()];
                    this.lookup.putAliases(validAliases.toArray(arr), curUnicode);
                }
            }
            if (shortcutsArray == null) continue;
            validAliases = new ArrayList();
            if (!EmojiContainer.validateAliases(containerName, shortcutsArray, validAliases::add)) continue;
            arr = new String[validAliases.size()];
            this.lookup.putShortcuts(validAliases.toArray(arr), curUnicode);
        }
    }

    public EmojiUnicodeLookup getLookup() {
        return this.lookup;
    }

    private static boolean validateAliases(String containerName, JsonArray aliasArray, Consumer<String> consumer) {
        boolean atLeastOne = false;
        for (JsonElement element : aliasArray) {
            String alias = element.getAsString();
            if (alias.isBlank() || alias.indexOf(32) != -1 || alias.indexOf(58) != -1) {
                FiguraMod.LOGGER.warn("Invalid emoji name \"{}\" in container: {}", (Object)alias, (Object)containerName);
                continue;
            }
            consumer.accept(alias);
            atLeastOne = true;
        }
        return atLeastOne;
    }

    public void tickAnimations() {
        for (EmojiMetadata metadata : this.lookup.metadataValues()) {
            metadata.tickAnimation();
        }
    }

    public class_2561 getEmojiComponent(String key) {
        return this.getEmojiComponent(key, class_2561.method_43470((String)(":" + key + ":")));
    }

    public class_2561 getEmojiComponent(String key, class_5250 hover) {
        String unicode = this.lookup.getUnicode(key);
        if (unicode == null) {
            return null;
        }
        return this.makeComponent(unicode, hover);
    }

    public class_2561 getShortcutComponent(String shortcut) {
        String unicode = this.lookup.getUnicodeForShortcut(shortcut);
        if (unicode == null) {
            return null;
        }
        return this.makeComponent(unicode, class_2561.method_43470((String)shortcut));
    }

    private class_2561 makeComponent(String unicode, class_5250 hover) {
        return class_2561.method_43470((String)unicode).method_27696(STYLE.method_27704(this.font).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hover.method_27693("\n").method_10852((class_2561)FiguraText.of("emoji." + this.name).method_27692(class_124.field_1063)))));
    }

    public class_2561 blacklist(class_2561 text) {
        if (this.blacklist.isBlank()) {
            return text;
        }
        return TextUtils.replaceInText((class_5348)text, "[" + this.blacklist + "]", TextUtils.UNKNOWN, (s, style) -> style.method_27708().equals((Object)this.font), Integer.MAX_VALUE);
    }

    public class_2960 getFont() {
        return this.font;
    }
}

