/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.figuramc.figura.font.EmojiContainer;
import org.figuramc.figura.font.EmojiUnicodeLookup;
import org.figuramc.figura.font.Emojis;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraClientCommandSource;

class EmojiListCommand {
    private static final class_2561 COMMA_SPACE = class_2561.method_43470((String)", ").method_27692(class_124.field_1080);

    EmojiListCommand() {
    }

    public static LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
        LiteralArgumentBuilder load = LiteralArgumentBuilder.literal((String)"emojis");
        RequiredArgumentBuilder path = RequiredArgumentBuilder.argument((String)"category", (ArgumentType)StringArgumentType.greedyString());
        path.suggests(EmojiListCommand::getSuggestions);
        path.executes(EmojiListCommand::listCategory);
        return (LiteralArgumentBuilder)load.then((ArgumentBuilder)path);
    }

    public static CompletableFuture<Suggestions> getSuggestions(CommandContext<FiguraClientCommandSource> context, SuggestionsBuilder builder) {
        builder.suggest("all");
        Emojis.getCategoryNames().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int listCategory(CommandContext<FiguraClientCommandSource> context) {
        FiguraClientCommandSource src = (FiguraClientCommandSource)context.getSource();
        String category = (String)context.getArgument("category", String.class);
        if (Objects.equals(category, "all")) {
            for (String curCategory : Emojis.getCategoryNames()) {
                if (!EmojiListCommand.printEmojis(curCategory, src::figura$sendFeedback, src::figura$sendError)) {
                    return 0;
                }
                src.figura$sendFeedback((class_2561)class_2561.method_43470((String)""));
            }
            return 1;
        }
        return EmojiListCommand.printEmojis(category, src::figura$sendFeedback, src::figura$sendError) ? 1 : 0;
    }

    private static boolean printEmojis(String category, Consumer<class_2561> feedback, Consumer<class_2561> error) {
        if (!Emojis.hasCategory(category)) {
            error.accept((class_2561)class_2561.method_43470((String)("Emoji category \"" + category + "\" doesn't exist!")));
            return false;
        }
        EmojiContainer container = Emojis.getCategory(category);
        Collection<String> unicodeValues = container.getLookup().unicodeValues();
        EmojiUnicodeLookup lookup = container.getLookup();
        feedback.accept((class_2561)class_2561.method_43470((String)String.format("--- %s (%s) ---", container.name, unicodeValues.size())).method_27696(ColorUtils.Colors.AWESOME_BLUE.style));
        class_5250 comp = class_2561.method_43470((String)"");
        unicodeValues.stream().sorted().forEach(unicode -> {
            String[] aliases = lookup.getNames((String)unicode);
            if (aliases != null) {
                class_5250 msg = class_2561.method_43470((String)"");
                for (int i = 0; i < aliases.length; ++i) {
                    msg.method_10852((class_2561)class_2561.method_43470((String)aliases[i]).method_27696(ColorUtils.Colors.AWESOME_BLUE.style));
                    if (i >= aliases.length - 1) continue;
                    msg.method_10852(COMMA_SPACE);
                }
                msg.method_10852((class_2561)class_2561.method_43470((String)("\ncodepoint: " + unicode.codePointAt(0))).method_27692(class_124.field_1080));
                comp.method_10852(Emojis.getEmoji(aliases[0], msg));
            }
        });
        feedback.accept((class_2561)comp);
        return true;
    }
}

