/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.avatar;

import com.mojang.datafixers.util.Pair;
import java.util.BitSet;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.lua.api.sound.SoundAPI;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class Badges {
    public static final class_2960 FONT = new FiguraIdentifier("badges");

    public static class_2561 fetchBadges(UUID id) {
        int i;
        if (PermissionManager.get(id).getCategory() == Permissions.Category.BLOCKED) {
            return class_2561.method_43473();
        }
        Pair<BitSet, BitSet> pair = AvatarManager.getBadges(id);
        if (pair == null) {
            return class_2561.method_43473();
        }
        class_5250 badges = class_2561.method_43473().method_27696(class_2583.field_24360.method_27704(FONT).method_10977(class_124.field_1068).method_36141(Boolean.valueOf(false)));
        Avatar avatar = AvatarManager.getAvatarForPlayer(id);
        if (avatar != null) {
            if (!avatar.loaded) {
                badges.method_10852((class_2561)class_2561.method_43470((String)Integer.toHexString(Math.abs(FiguraMod.ticks) % 16)));
            } else if (avatar.nbt != null) {
                block20: {
                    BitSet prideSet = (BitSet)pair.getFirst();
                    Pride[] pride = Pride.values();
                    for (i = pride.length - 1; i >= 0; --i) {
                        if (!prideSet.get(i)) continue;
                        badges.method_10852(pride[i].badge);
                        break block20;
                    }
                    badges.method_10852((class_2561)System.DEFAULT.badge.method_27661().method_27696(class_2583.field_24360.method_36139(ColorUtils.rgbToInt(ColorUtils.userInputHex(avatar.color)))));
                }
                if (avatar.scriptError) {
                    if (avatar.errorText == null) {
                        badges.method_10852(System.ERROR.badge);
                    } else {
                        badges.method_10852((class_2561)System.ERROR.badge.method_27661().method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)System.ERROR.desc.method_27661().method_27693("\n\n").method_10852(avatar.errorText)))));
                    }
                }
                if (avatar.versionStatus > 0) {
                    badges.method_10852(System.WARNING.badge);
                }
                if (!avatar.noPermissions.isEmpty()) {
                    class_5250 badge = System.PERMISSIONS.badge.method_27661();
                    class_5250 desc = System.PERMISSIONS.desc.method_27661().method_27693("\n");
                    for (Permissions t : avatar.noPermissions) {
                        desc.method_27693("\n\u2022 ").method_10852((class_2561)FiguraText.of("badges.no_permissions." + t.name.toLowerCase(Locale.US)));
                    }
                    badges.method_10852((class_2561)badge.method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)desc))));
                }
            }
        }
        if (avatar != null) {
            BitSet specialSet = (BitSet)pair.getSecond();
            Special[] specialValues = Special.values();
            for (i = specialValues.length - 1; i >= 0; --i) {
                if (!specialSet.get(i)) continue;
                Special special = specialValues[i];
                Integer color = special.color;
                if (avatar.badgeToColor.containsKey(special.name().toLowerCase(Locale.US))) {
                    color = ColorUtils.rgbToInt(ColorUtils.userInputHex(avatar.badgeToColor.get(special.name().toLowerCase(Locale.US))));
                }
                class_2561 badge = color != null ? special.badge.method_27661().method_27696(class_2583.field_24360.method_36139(color.intValue())) : special.badge;
                badges.method_10852(badge);
            }
        }
        if (avatar != null && ((Boolean)Configs.SOUND_BADGE.value).booleanValue()) {
            if (avatar.lastPlayingSound > 0) {
                badges.method_10852(System.SOUND.badge);
            } else if (SoundAPI.getSoundEngine().figura$isPlaying(id)) {
                avatar.lastPlayingSound = 20;
                badges.method_10852(System.SOUND.badge);
            }
        }
        return badges;
    }

    public static class_2561 noBadges4U(class_2561 text) {
        return TextUtils.replaceInText((class_5348)text, "[-*/+=\u2757\u274c\ud83d\udee1\u2605\u2606\u2764\u6587\u2712\ud83d\uddff0-9a-f]", TextUtils.UNKNOWN, (s, style) -> style.method_27708().equals((Object)FONT) || style.method_27708().equals((Object)UIHelper.UI_FONT), Integer.MAX_VALUE);
    }

    public static Pair<BitSet, BitSet> emptyBadges() {
        return Pair.of((Object)new BitSet(Pride.values().length), (Object)new BitSet(Special.values().length));
    }

    public static boolean hasCustomBadges(class_2561 text) {
        return text.method_27658((style, string) -> string.contains("${badges}") || string.contains("${segdab}") ? class_5348.field_25309 : Optional.empty(), class_2583.field_24360).isPresent();
    }

    public static class_2561 appendBadges(class_2561 text, UUID id, boolean allow) {
        class_5250 badges = allow ? Badges.fetchBadges(id) : class_2561.method_43473();
        boolean custom = Badges.hasCustomBadges(text);
        if (!custom) {
            return badges.getString().isBlank() ? text : text.method_27661().method_27693(" ").method_10852((class_2561)badges);
        }
        text = TextUtils.replaceInText((class_5348)text, "\\$\\{badges\\}(?s)", badges);
        text = TextUtils.replaceInText((class_5348)text, "\\$\\{segdab\\}(?s)", TextUtils.reverse((class_5348)badges));
        return text;
    }

    public static enum Pride {
        AGENDER("\u16a0"),
        AROACE("\u16a1"),
        AROMANTIC("\u16a2"),
        ASEXUAL("\u16a3"),
        BIGENDER("\u16a4"),
        BISEXUAL("\u16a5"),
        DEMIBOY("\u16a6"),
        DEMIGENDER("\u16a7"),
        DEMIGIRL("\u16a8"),
        DEMIROMANTIC("\u16a9"),
        DEMISEXUAL("\u16aa"),
        DISABILITY("\u16ab"),
        FINSEXUAL("\u16ac"),
        GAYMEN("\u16ad"),
        GENDERFAE("\u16ae"),
        GENDERFLUID("\u16af"),
        GENDERQUEER("\u16b0"),
        INTERSEX("\u16b1"),
        LESBIAN("\u16b2"),
        NONBINARY("\u16b3"),
        PANSEXUAL("\u16b4"),
        PLURAL("\u16b5"),
        POLYSEXUAL("\u16b6"),
        PRIDE("\u16b7"),
        TRANSGENDER("\u16b8");

        public final class_2561 badge;
        public final class_2561 desc = FiguraText.of("badges.pride." + this.name().toLowerCase(Locale.US));

        private Pride(String unicode) {
            this.badge = class_2561.method_43470((String)unicode).method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)this.desc)));
        }
    }

    public static enum System {
        DEFAULT("\u25b3"),
        PERMISSIONS("\ud83d\udee1"),
        WARNING("\u2757"),
        ERROR("\u274c"),
        SOUND("\ud83d\udd0a");

        public final class_2561 badge;
        public final class_2561 desc = FiguraText.of("badges.system." + this.name().toLowerCase(Locale.US));

        private System(String unicode) {
            this.badge = class_2561.method_43470((String)unicode).method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)this.desc)));
        }
    }

    public static enum Special {
        DEV("\u2605"),
        DISCORD_STAFF("\u2606", ColorUtils.Colors.DISCORD.hex),
        CONTEST("\u2606", ColorUtils.Colors.AWESOME_BLUE.hex),
        DONATOR("\u2764", ColorUtils.Colors.AWESOME_BLUE.hex),
        TRANSLATOR("\u6587"),
        TEXTURE_ARTIST("\u2712"),
        IMMORTALIZED("\ud83d\uddff");

        public final class_2561 badge;
        public final class_2561 desc = FiguraText.of("badges.special." + this.name().toLowerCase(Locale.US));
        public final Integer color;

        private Special(String unicode) {
            this(unicode, null);
        }

        private Special(String unicode, Integer color) {
            class_2583 style = class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)this.desc));
            if (color != null) {
                style = style.method_36139(color.intValue());
            }
            this.color = color;
            this.badge = class_2561.method_43470((String)unicode).method_27696(style);
        }
    }
}

