/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.event.ForgeEventFactory;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.biomes.TFBiomeDecorator;
import twilightforest.block.TFBlocks;
import twilightforest.util.IntPair;
import twilightforest.world.ChunkBitArray;
import twilightforest.world.MapGenTFHollowTree;
import twilightforest.world.MapGenTFMajorFeature;

public abstract class ChunkGeneratorTFBase
implements IChunkGenerator {
    protected final Random rand;
    private final NoiseGeneratorOctaves minLimitPerlinNoise;
    private final NoiseGeneratorOctaves maxLimitPerlinNoise;
    private final NoiseGeneratorOctaves mainPerlinNoise;
    private final NoiseGeneratorPerlin surfaceNoise;
    private final NoiseGeneratorOctaves depthNoise;
    protected final World world;
    protected final WorldType terrainType;
    private double[] mainNoiseRegion;
    private double[] minLimitRegion;
    private double[] maxLimitRegion;
    private double[] depthRegion;
    protected double[] depthBuffer = new double[256];
    protected Biome[] biomesForGeneration;
    private final double[] heightMap;
    private final float[] biomeWeights;
    protected final MapGenTFHollowTree hollowTreeGenerator = new MapGenTFHollowTree();
    protected final Map<TFFeature, MapGenTFMajorFeature> featureGenerators = new EnumMap<TFFeature, MapGenTFMajorFeature>(TFFeature.class);
    protected final MapGenTFMajorFeature nothingGenerator = new MapGenTFMajorFeature();
    private final boolean shouldGenerateBedrock;

    protected static long getSeed(int x, int z) {
        return (long)x * 341873128712L + (long)z * 132897987541L;
    }

    protected static int getIndex(int x, int y, int z) {
        return x << 12 | z << 8 | y;
    }

    public ChunkGeneratorTFBase(World world, long seed, boolean enableFeatures, boolean shouldGenerateBedrock) {
        this.world = world;
        this.terrainType = world.func_72912_H().func_76067_t();
        this.rand = new Random(seed);
        this.shouldGenerateBedrock = shouldGenerateBedrock;
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.biomeWeights[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
        for (TFFeature feature : TFFeature.values()) {
            MapGenTFMajorFeature generator = feature.createFeatureGenerator();
            if (generator == null) continue;
            this.featureGenerators.put(feature, generator);
        }
    }

    protected final void generateFeatures(int x, int z, ChunkPrimer primer) {
        for (MapGenTFMajorFeature generator : this.featureGenerators.values()) {
            generator.func_186125_a(this.world, x, z, primer);
        }
    }

    protected final Chunk makeChunk(int x, int z, ChunkPrimer primer) {
        Chunk chunk = new Chunk(this.world, x, z);
        this.fillChunk(chunk, primer);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void fillChunk(Chunk chunk, ChunkPrimer primer) {
        int i = 256;
        boolean flag = this.world.field_73011_w.func_191066_m();
        ExtendedBlockStorage[] storageArrays = chunk.func_76587_i();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 256; ++l) {
                    IBlockState iblockstate = primer.func_177856_a(j, l, k);
                    if (iblockstate.func_177230_c() == Blocks.field_150350_a) continue;
                    int i1 = l >> 4;
                    if (storageArrays[i1] == Chunk.field_186036_a) {
                        storageArrays[i1] = new ExtendedBlockStorage(i1 << 4, flag);
                    }
                    storageArrays[i1].func_177484_a(j, l & 0xF, k, iblockstate);
                }
            }
        }
    }

    protected final void setBlocksInChunk(int x, int z, ChunkBitArray data) {
        int seaLevel = 63;
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
        this.generateHeightmap(x * 4, 0, z * 4);
        for (int k = 0; k < 4; ++k) {
            int l = k * 5;
            int i1 = (k + 1) * 5;
            for (int j1 = 0; j1 < 4; ++j1) {
                int k1 = (l + j1) * 33;
                int l1 = (l + j1 + 1) * 33;
                int i2 = (i1 + j1) * 33;
                int j2 = (i1 + j1 + 1) * 33;
                for (int k2 = 0; k2 < 32; ++k2) {
                    double d0 = 0.125;
                    double d1 = this.heightMap[k1 + k2];
                    double d2 = this.heightMap[l1 + k2];
                    double d3 = this.heightMap[i2 + k2];
                    double d4 = this.heightMap[j2 + k2];
                    double d5 = (this.heightMap[k1 + k2 + 1] - d1) * d0;
                    double d6 = (this.heightMap[l1 + k2 + 1] - d2) * d0;
                    double d7 = (this.heightMap[i2 + k2 + 1] - d3) * d0;
                    double d8 = (this.heightMap[j2 + k2 + 1] - d4) * d0;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double d15 = d10 - d16;
                            for (int k3 = 0; k3 < 4; ++k3) {
                                double d;
                                d15 += d16;
                                if (!(d > 0.0)) continue;
                                data.set(ChunkGeneratorTFBase.getIndex(k * 4 + i3, k2 * 8 + l2, j1 * 4 + k3));
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void generateHeightmap(int x, int zero, int z) {
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, x, z, 5, 5, 200.0, 200.0, 0.5);
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, x, zero, z, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        int terrainIndex = 0;
        int noiseIndex = 0;
        for (int ax = 0; ax < 5; ++ax) {
            for (int az = 0; az < 5; ++az) {
                float totalVariation = 0.0f;
                float totalHeight = 0.0f;
                float totalFactor = 0.0f;
                int two = 2;
                Biome biome = this.biomesForGeneration[ax + 2 + (az + 2) * 10];
                for (int ox = -two; ox <= two; ++ox) {
                    for (int oz = -two; oz <= two; ++oz) {
                        Biome biome1 = this.biomesForGeneration[ax + ox + 2 + (az + oz + 2) * 10];
                        float rootHeight = biome1.func_185355_j();
                        float heightVariation = biome1.func_185360_m();
                        if (this.terrainType == WorldType.field_151360_e && rootHeight > 0.0f) {
                            rootHeight = 1.0f + rootHeight * 2.0f;
                            heightVariation = 1.0f + heightVariation * 4.0f;
                        }
                        float heightFactor = this.biomeWeights[ox + 2 + (oz + 2) * 5] / (rootHeight + 2.0f);
                        if (biome1.func_185355_j() > biome.func_185355_j()) {
                            heightFactor /= 2.0f;
                        }
                        totalVariation += heightVariation * heightFactor;
                        totalHeight += rootHeight * heightFactor;
                        totalFactor += heightFactor;
                    }
                }
                totalVariation /= totalFactor;
                totalHeight /= totalFactor;
                totalVariation = totalVariation * 0.9f + 0.1f;
                totalHeight = (totalHeight * 4.0f - 1.0f) / 8.0f;
                double terrainNoise = this.depthRegion[noiseIndex] / 8000.0;
                if (terrainNoise < 0.0) {
                    terrainNoise = -terrainNoise * 0.3;
                }
                if ((terrainNoise = terrainNoise * 3.0 - 2.0) < 0.0) {
                    if ((terrainNoise /= 2.0) < -1.0) {
                        terrainNoise = -1.0;
                    }
                    terrainNoise /= 1.4;
                    terrainNoise /= 2.0;
                } else {
                    if (terrainNoise > 1.0) {
                        terrainNoise = 1.0;
                    }
                    terrainNoise /= 8.0;
                }
                ++noiseIndex;
                double heightCalc = totalHeight;
                double variationCalc = totalVariation;
                heightCalc += terrainNoise * 0.2;
                heightCalc = heightCalc * 8.5 / 8.0;
                double d5 = 8.5 + heightCalc * 4.0;
                for (int ay = 0; ay < 33; ++ay) {
                    double d6 = ((double)ay - d5) * 12.0 * 128.0 / 256.0 / variationCalc;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.minLimitRegion[terrainIndex] / 512.0;
                    double d8 = this.maxLimitRegion[terrainIndex] / 512.0;
                    double d9 = (this.mainNoiseRegion[terrainIndex] / 10.0 + 1.0) / 2.0;
                    double terrainCalc = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (ay > 29) {
                        double d11 = (float)(ay - 29) / 3.0f;
                        terrainCalc = terrainCalc * (1.0 - d11) + -10.0 * d11;
                    }
                    this.heightMap[terrainIndex] = terrainCalc;
                    ++terrainIndex;
                }
            }
        }
    }

    protected final void squishTerrain(ChunkBitArray data) {
        int squishHeight = 128;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                for (y = 0; y < squishHeight; ++y) {
                    data.set(ChunkGeneratorTFBase.getIndex(x, y, z), data.get(ChunkGeneratorTFBase.getIndex(x, y * 2 + 1, z)));
                }
                for (y = squishHeight; y < 256; ++y) {
                    data.clear(ChunkGeneratorTFBase.getIndex(x, y, z));
                }
            }
        }
    }

    protected abstract void initPrimer(ChunkPrimer var1, ChunkBitArray var2);

    public void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        double d0 = 0.03125;
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomesIn[j + i * 16];
                biome.func_180622_a(this.world, this.rand, primer, x * 16 + i, z * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    protected final void deformTerrainForFeature(int cx, int cz, ChunkPrimer primer) {
        IntPair nearCenter = new IntPair();
        TFFeature nearFeature = TFFeature.getNearestFeature(cx, cz, this.world, nearCenter);
        if (!nearFeature.isTerrainAltered) {
            return;
        }
        int hx = nearCenter.x;
        int hz = nearCenter.z;
        if (nearFeature == TFFeature.TROLL_CAVE) {
            this.deformTerrainForTrollCloud2(primer, nearFeature, cx, cz, hx, hz);
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int dx = x - hx;
                int dz = z - hz;
                if (nearFeature == TFFeature.SMALL_HILL || nearFeature == TFFeature.MEDIUM_HILL || nearFeature == TFFeature.LARGE_HILL || nearFeature == TFFeature.HYDRA_LAIR) {
                    int hdiam = (nearFeature.size * 2 + 1) * 16;
                    int dist = (int)Math.sqrt(dx * dx + dz * dz);
                    int hheight = (int)(Math.cos((double)((float)dist / (float)hdiam) * Math.PI) * (double)((float)hdiam / 3.0f));
                    this.raiseHills(primer, nearFeature, hdiam, x, z, dx, dz, hheight);
                    continue;
                }
                if (nearFeature == TFFeature.HEDGE_MAZE || nearFeature == TFFeature.NAGA_COURTYARD || nearFeature == TFFeature.QUEST_GROVE) {
                    this.flattenTerrainForFeature(primer, nearFeature, x, z, dx, dz);
                    continue;
                }
                if (nearFeature == TFFeature.YETI_CAVE) {
                    this.deformTerrainForYetiLair(primer, nearFeature, x, z, dx, dz);
                    continue;
                }
                if (nearFeature != TFFeature.TROLL_CAVE) continue;
                this.deformTerrainForTrollCaves(primer, nearFeature, x, z, dx, dz);
            }
        }
    }

    private void raiseHills(ChunkPrimer primer, TFFeature nearFeature, int hdiam, int x, int z, int dx, int dz, int hillHeight) {
        int y;
        int y2;
        int oldGround = -1;
        int newGround = -1;
        boolean foundGroundLevel = false;
        for (y2 = 31; y2 < 256; ++y2) {
            Block currentTerrain = primer.func_177856_a(x, y2, z).func_177230_c();
            if (currentTerrain == Blocks.field_150348_b) continue;
            oldGround = y2;
            newGround = y2 + hillHeight;
            foundGroundLevel = true;
            break;
        }
        if (foundGroundLevel) {
            for (y2 = oldGround; y2 <= newGround; ++y2) {
                primer.func_177855_a(x, y2, z, Blocks.field_150348_b.func_176223_P());
            }
        }
        int hollow = hillHeight - 4 - nearFeature.size;
        if (nearFeature == TFFeature.HYDRA_LAIR) {
            int mx = dx + 16;
            int mz = dz + 16;
            int mdist = (int)Math.sqrt(mx * mx + mz * mz);
            int mheight = (int)(Math.cos((double)mdist / ((double)hdiam / 1.5) * Math.PI) * ((double)hdiam / 1.5));
            hollow = Math.max(mheight - 4, hollow);
        }
        if (hollow < 0) {
            hollow = 0;
        }
        int hollowFloor = 28 - hollow / 8;
        if (nearFeature == TFFeature.HYDRA_LAIR) {
            hollowFloor = 31;
        }
        if (hillHeight > 0) {
            for (y = 0; y < 31; ++y) {
                if (primer.func_177856_a(x, y, z).func_177230_c() == Blocks.field_150348_b) continue;
                primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
            }
        }
        for (y = hollowFloor + 1; y < hollowFloor + hollow; ++y) {
            primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
        }
    }

    private void flattenTerrainForFeature(ChunkPrimer primer, TFFeature nearFeature, int x, int z, int dx, int dz) {
        Block b;
        int y;
        float squishFactor = 0.0f;
        int mazeHeight = 32;
        int FEATURE_BOUNDARY = (nearFeature.size * 2 + 1) * 8 - 8;
        if (dx <= -FEATURE_BOUNDARY) {
            squishFactor = (float)(-dx - FEATURE_BOUNDARY) / 8.0f;
        } else if (dx >= FEATURE_BOUNDARY) {
            squishFactor = (float)(dx - FEATURE_BOUNDARY) / 8.0f;
        }
        if (dz <= -FEATURE_BOUNDARY) {
            squishFactor = Math.max(squishFactor, (float)(-dz - FEATURE_BOUNDARY) / 8.0f);
        } else if (dz >= FEATURE_BOUNDARY) {
            squishFactor = Math.max(squishFactor, (float)(dz - FEATURE_BOUNDARY) / 8.0f);
        }
        if (squishFactor > 0.0f) {
            for (y = 0; y <= 127; ++y) {
                Block currentTerrain = primer.func_177856_a(x, y, z).func_177230_c();
                if (currentTerrain == Blocks.field_150348_b) continue;
                mazeHeight = (int)((float)mazeHeight + (float)(y - mazeHeight) * squishFactor);
                break;
            }
        }
        for (y = 0; y < mazeHeight; ++y) {
            b = primer.func_177856_a(x, y, z).func_177230_c();
            if (b != Blocks.field_150350_a && b != Blocks.field_150355_j) continue;
            primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
        }
        for (y = mazeHeight; y <= 127; ++y) {
            b = primer.func_177856_a(x, y, z).func_177230_c();
            if (b == Blocks.field_150350_a || b == Blocks.field_150355_j) continue;
            primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
        }
    }

    private void deformTerrainForYetiLair(ChunkPrimer primer, TFFeature nearFeature, int x, int z, int dx, int dz) {
        int y;
        float squishFactor = 0.0f;
        int topHeight = 55;
        int outerBoundary = (nearFeature.size * 2 + 1) * 8 - 8;
        if (dx <= -outerBoundary) {
            squishFactor = (float)(-dx - outerBoundary) / 8.0f;
        } else if (dx >= outerBoundary) {
            squishFactor = (float)(dx - outerBoundary) / 8.0f;
        }
        if (dz <= -outerBoundary) {
            squishFactor = Math.max(squishFactor, (float)(-dz - outerBoundary) / 8.0f);
        } else if (dz >= outerBoundary) {
            squishFactor = Math.max(squishFactor, (float)(dz - outerBoundary) / 8.0f);
        }
        int caveBoundary = nearFeature.size * 2 * 8 - 8;
        int hollowCeiling = 47;
        int offset = Math.min(Math.abs(dx), Math.abs(dz));
        hollowCeiling = 71 - offset * 4;
        if (dx >= -caveBoundary && dz >= -caveBoundary && dx <= caveBoundary && dz <= caveBoundary) {
            hollowCeiling = 47;
        }
        hollowCeiling -= offset / 6;
        hollowCeiling = Math.min(hollowCeiling, 47);
        int hollowFloor = 30 + offset / 6;
        if (squishFactor > 0.0f) {
            for (y = 0; y <= 127; ++y) {
                Block currentTerrain = primer.func_177856_a(x, y, z).func_177230_c();
                if (currentTerrain == Blocks.field_150348_b) continue;
                topHeight = (int)((float)topHeight + (float)(y - topHeight) * squishFactor);
                hollowFloor = (int)((float)hollowFloor + (float)(y - hollowFloor) * squishFactor);
                break;
            }
        }
        for (y = 0; y < topHeight; ++y) {
            Block b = primer.func_177856_a(x, y, z).func_177230_c();
            if (b != Blocks.field_150350_a && b != Blocks.field_150355_j) continue;
            primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
        }
        for (y = hollowFloor + 1; y < hollowCeiling; ++y) {
            primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
        }
        if (hollowFloor < hollowCeiling && hollowFloor < 34) {
            primer.func_177855_a(x, hollowFloor, z, Blocks.field_150403_cj.func_176223_P());
        }
    }

    protected void deformTerrainForTrollCaves(ChunkPrimer primer, TFFeature nearFeature, int x, int z, int dx, int dz) {
    }

    private void deformTerrainForTrollCloud2(ChunkPrimer primer, TFFeature nearFeature, int cx, int cz, int hx, int hz) {
        for (int bx = 0; bx < 4; ++bx) {
            for (int bz = 0; bz < 4; ++bz) {
                int dx = bx * 4 - hx - 2;
                int dz = bz * 4 - hz - 2;
                int regionX = cx + 8 >> 4;
                int regionZ = cz + 8 >> 4;
                long seed = (long)(regionX * 3129871) ^ (long)regionZ * 116129781L;
                seed = seed * seed * 42317861L + seed * 7L;
                int num0 = (int)(seed >> 12 & 3L);
                int num1 = (int)(seed >> 15 & 3L);
                int num2 = (int)(seed >> 18 & 3L);
                int num3 = (int)(seed >> 21 & 3L);
                int num4 = (int)(seed >> 9 & 3L);
                int num5 = (int)(seed >> 6 & 3L);
                int num6 = (int)(seed >> 3 & 3L);
                int num7 = (int)(seed >> 0 & 3L);
                int dx2 = dx + num0 * 5 - num1 * 4;
                int dz2 = dz + num2 * 4 - num3 * 5;
                int dx3 = dx + num4 * 5 - num5 * 4;
                int dz3 = dz + num6 * 4 - num7 * 5;
                double dist0 = Math.sqrt(dx * dx + dz * dz) / 4.0;
                double dist2 = Math.sqrt(dx2 * dx2 + dz2 * dz2) / 3.5;
                double dist3 = Math.sqrt(dx3 * dx3 + dz3 * dz3) / 4.5;
                double dist = Math.min(dist0, Math.min(dist2, dist3));
                float pr = this.world.field_73012_v.nextFloat();
                double cv = dist - 7.0 - (double)(pr * 3.0f);
                int y = 166;
                int depth = 4;
                if (pr < 0.1f) {
                    ++y;
                }
                if (pr > 0.6f) {
                    ++depth;
                }
                if (pr > 0.9f) {
                    ++depth;
                }
                for (int sx = 0; sx < 4; ++sx) {
                    for (int sz = 0; sz < 4; ++sz) {
                        int d;
                        int lx = bx * 4 + sx;
                        int lz = bz * 4 + sz;
                        if (dist < 7.0 || cv < (double)0.05f) {
                            primer.func_177855_a(lx, y, lz, TFBlocks.wispy_cloud.func_176223_P());
                            for (d = 1; d < depth; ++d) {
                                primer.func_177855_a(lx, y - d, lz, TFBlocks.fluffy_cloud.func_176223_P());
                            }
                            primer.func_177855_a(lx, y - depth, lz, TFBlocks.wispy_cloud.func_176223_P());
                            continue;
                        }
                        if (!(dist < 8.0) && !(cv < 1.0)) continue;
                        for (d = 1; d < depth; ++d) {
                            primer.func_177855_a(lx, y - d, lz, TFBlocks.fluffy_cloud.func_176223_P());
                        }
                    }
                }
            }
        }
    }

    protected final boolean allowSurfaceLakes(Biome biome) {
        if (biome.field_76760_I instanceof TFBiomeDecorator) {
            return !((TFBiomeDecorator)biome.field_76760_I).hasCanopy;
        }
        return true;
    }

    public final boolean shouldGenerateBedrock() {
        return this.shouldGenerateBedrock;
    }

    public boolean func_185933_a(Chunk chunk, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        TFFeature nearestFeature = TFFeature.getFeatureForRegionPos(pos.func_177958_n(), pos.func_177952_p(), this.world);
        List<Biome.SpawnListEntry> featureList = this.getFeatureGenerator(nearestFeature).getPossibleCreatures(creatureType, pos);
        if (featureList != null) {
            return featureList;
        }
        Biome biome = this.world.func_180494_b(pos);
        if (pos.func_177956_o() < 31 && biome instanceof TFBiomeBase) {
            return ((TFBiomeBase)biome).getUndergroundSpawnableList(creatureType);
        }
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World world, String structureName, BlockPos position, boolean findUnexplored) {
        if (structureName.equalsIgnoreCase(this.hollowTreeGenerator.func_143025_a())) {
            return this.hollowTreeGenerator.func_180706_b(world, position, findUnexplored);
        }
        TFFeature feature = TFFeature.getFeatureByName(new ResourceLocation(structureName));
        if (feature != TFFeature.NOTHING) {
            return TFFeature.findNearestFeaturePosBySpacing(world, feature, position, 20, 11, 10387313, true, 100, findUnexplored);
        }
        return null;
    }

    protected final MapGenTFMajorFeature getFeatureGenerator(TFFeature feature) {
        return this.featureGenerators.getOrDefault((Object)feature, this.nothingGenerator);
    }

    public void setStructureConquered(BlockPos pos, boolean flag) {
        this.getFeatureGenerator(TFFeature.getFeatureForRegionPos(pos.func_177958_n(), pos.func_177952_p(), this.world)).setStructureConquered(pos, flag);
    }

    public boolean isStructureLocked(BlockPos pos, int lockIndex) {
        return this.getFeatureGenerator(TFFeature.getFeatureForRegionPos(pos.func_177958_n(), pos.func_177952_p(), this.world)).isStructureLocked(pos, lockIndex);
    }

    public boolean isBlockInStructureBB(BlockPos pos) {
        return this.getFeatureGenerator(TFFeature.getFeatureForRegionPos(pos.func_177958_n(), pos.func_177952_p(), this.world)).func_175795_b(pos);
    }

    @Nullable
    public StructureBoundingBox getSBBAt(BlockPos pos) {
        return this.getFeatureGenerator(TFFeature.getFeatureForRegionPos(pos.func_177958_n(), pos.func_177952_p(), this.world)).getSBBAt(pos);
    }

    public boolean isBlockProtected(BlockPos pos) {
        return this.getFeatureGenerator(TFFeature.getFeatureForRegionPos(pos.func_177958_n(), pos.func_177952_p(), this.world)).isBlockProtectedAt(pos);
    }

    public boolean isStructureConquered(BlockPos pos) {
        return this.getFeatureGenerator(TFFeature.getFeatureForRegionPos(pos.func_177958_n(), pos.func_177952_p(), this.world)).isStructureConquered(pos);
    }

    public boolean isBlockInFullStructure(int x, int z) {
        return this.getFeatureGenerator(TFFeature.getFeatureForRegionPos(x, z, this.world)).isBlockInFullStructure(x, z);
    }

    public boolean isBlockNearFullStructure(int x, int z, int range) {
        return this.getFeatureGenerator(TFFeature.getFeatureForRegionPos(x, z, this.world)).isBlockNearFullStructure(x, z, range);
    }

    @Nullable
    public StructureBoundingBox getFullSBBNear(int mapX, int mapZ, int range) {
        return this.getFeatureGenerator(TFFeature.getFeatureForRegionPos(mapX, mapZ, this.world)).getFullSBBNear(mapX, mapZ, range);
    }

    public TFFeature getFeatureAt(BlockPos pos) {
        return this.getFeatureGenerator(TFFeature.getFeatureForRegionPos(pos.func_177958_n(), pos.func_177952_p(), this.world)).getFeatureAt(pos);
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
        for (MapGenTFMajorFeature generator : this.featureGenerators.values()) {
            generator.func_186125_a(this.world, x, z, null);
        }
    }

    public boolean func_193414_a(World world, String structureName, BlockPos pos) {
        if (structureName.equalsIgnoreCase(this.hollowTreeGenerator.func_143025_a())) {
            return this.hollowTreeGenerator.func_175795_b(pos);
        }
        TFFeature feature = TFFeature.getFeatureByName(new ResourceLocation(structureName));
        return feature != TFFeature.NOTHING && this.getFeatureGenerator(feature).func_175795_b(pos);
    }
}

