/*
 * Decompiled with CFR 0.152.
 */
package mcjty.nice.particle.systems;

import java.util.List;
import mcjty.nice.particle.DefaultCalculatedParticleSystem;
import mcjty.nice.particle.DefaultParticle;
import mcjty.nice.particle.ICalculatedParticleSystem;
import mcjty.nice.particle.IParticle;
import mcjty.nice.particle.IParticleSystem;
import net.minecraft.util.math.Vec3d;

public class BubbleSystem
implements IParticleSystem {
    private static Vec3d[] offsets = new Vec3d[6];

    @Override
    public ICalculatedParticleSystem createCalculatedParticleSystem(float scale) {
        DefaultCalculatedParticleSystem calculated = new DefaultCalculatedParticleSystem(offsets.length, scale);
        List<IParticle> particles = calculated.getParticles();
        for (int i = 0; i < offsets.length; ++i) {
            DefaultParticle particle = (DefaultParticle)particles.get(i);
            particle.setScale(0.13);
            particle.setUV(0.625, 0.0, 0.75, 0.125);
            particle.setColor(255, 255, 255, 128);
        }
        return calculated;
    }

    @Override
    public void update(ICalculatedParticleSystem calculated, long time) {
        List<IParticle> particles = calculated.getParticles();
        for (int i = 0; i < offsets.length; ++i) {
            Vec3d o = offsets[i];
            float offset = (float)(time % 2000L) / 2000.0f;
            double ox = o.field_72450_a * (double)calculated.getScale() / (double)0.8f;
            double oy = (o.field_72448_b + (double)offset + 0.5) % 1.0 - 0.5;
            double oz = o.field_72449_c * (double)calculated.getScale() / (double)0.8f;
            DefaultParticle particle = (DefaultParticle)particles.get(i);
            particle.setOffset(new Vec3d(ox, oy, oz));
        }
    }

    static {
        BubbleSystem.offsets[0] = new Vec3d(0.0, (double)0.43f, (double)0.2f);
        BubbleSystem.offsets[1] = new Vec3d((double)-0.3f, (double)0.3f, 0.0);
        BubbleSystem.offsets[2] = new Vec3d((double)0.1f, 0.0, (double)-0.3f);
        BubbleSystem.offsets[3] = new Vec3d(0.0, (double)0.16f, (double)0.27f);
        BubbleSystem.offsets[4] = new Vec3d((double)0.2f, (double)-0.4f, (double)-0.21f);
        BubbleSystem.offsets[5] = new Vec3d((double)-0.17f, -0.25, (double)-0.2f);
    }
}

