/*
 * Decompiled with CFR 0.152.
 */
package mcjty.nice.particle.systems;

import java.util.Random;
import mcjty.nice.particle.DefaultCalculatedParticleSystem;
import mcjty.nice.particle.DefaultParticle;
import net.minecraft.util.math.Vec3d;

public class BlinkCalculatedSystem
extends DefaultCalculatedParticleSystem {
    private static Random random = new Random();
    private static long[] offsets = new long[]{1000L, 500L, 200L, 343L, 708L, 1700L, 3L, 1200L, 1493L, 1200L};

    public BlinkCalculatedSystem(float scale) {
        super(offsets.length, scale);
        int amount = this.particles.size();
        for (int i = 0; i < amount; ++i) {
            DefaultParticle particle = (DefaultParticle)this.particles.get(i);
            Vec3d o = new Vec3d(random.nextDouble() * (double)scale - (double)(scale / 2.0f), random.nextDouble() * 0.8 - 0.4, random.nextDouble() * (double)scale - (double)(scale / 2.0f));
            particle.setOffset(o);
            particle.setUV(0.5, 0.0, 0.625, 0.125);
            particle.setColor(255, 255, 255, 128);
            particle.setScale(0.2);
        }
    }

    public void update(long time) {
        for (int i = 0; i < this.particles.size(); ++i) {
            DefaultParticle particle = (DefaultParticle)this.particles.get(i);
            float offset = (float)((time + offsets[i]) % 1000L) / 1000.0f;
            if ((double)offset > 0.5) {
                offset = 1.0f - offset;
            }
            particle.setScale(offset * 0.3f);
            if (!((double)offset < 0.001)) continue;
            Vec3d o = new Vec3d(random.nextDouble() * 0.8 - 0.4, random.nextDouble() * 0.8 - 0.4, random.nextDouble() * 0.8 - 0.4);
            particle.setOffset(o);
        }
    }
}

