/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.effects.BaseEffectDataMap;
import com.rwtema.careerbees.effects.EffectBase;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.genetics.IEffectData;
import gnu.trove.list.array.TLongArrayList;
import java.util.Random;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class EffectBaseThrottled
extends EffectBase {
    public final float baseTicksBetweenProcessing;
    public final float chanceOfProcessing;
    @Nullable
    final WeakHashMap<IBeeHousing, Long> lastTickTime = BeeMod.deobf ? new WeakHashMap() : null;
    @Nullable
    final TLongArrayList times = BeeMod.deobf ? new TLongArrayList() : null;

    public EffectBaseThrottled(String name, float baseTicksBetweenProcessing) {
        this(name, false, false, baseTicksBetweenProcessing, 1.0f);
    }

    public EffectBaseThrottled(String name, int baseTicksBetweenProcessing, float chanceOfProcessing) {
        this(name, false, false, baseTicksBetweenProcessing, chanceOfProcessing);
    }

    public EffectBaseThrottled(String name, boolean isDominant, boolean isCombinable, float baseTicksBetweenProcessing, float chanceOfProcessing) {
        super(name, isDominant, isCombinable);
        this.baseTicksBetweenProcessing = baseTicksBetweenProcessing;
        this.chanceOfProcessing = chanceOfProcessing;
    }

    @Override
    @Nonnull
    public IEffectData validateStorage(@Nullable IEffectData storedData) {
        if (storedData instanceof BaseEffectDataMap.IntMap) {
            return storedData;
        }
        return new BaseEffectDataMap.IntMap();
    }

    @Override
    @Nonnull
    public IEffectData doEffectBase(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, IEffectSettingsHolder settings) {
        long totalWorldTime;
        Long prevTime;
        int time = storedData.getInteger(0);
        storedData.setInteger(0, ++time);
        World world = housing.getWorldObj();
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(world);
        IBeeModifier beeHousingModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        IBeeModifier beeModeModifier = mode.getBeeModifier();
        float speed = EffectBaseThrottled.getSpeed(genome, housing);
        if ((float)time * speed < this.baseTicksBetweenProcessing) {
            return storedData;
        }
        storedData.setInteger(0, 0);
        if (this.chanceOfProcessing < 1.0f && world.field_73012_v.nextFloat() > this.chanceOfProcessing) {
            return storedData;
        }
        if (BeeMod.deobf && (prevTime = this.lastTickTime.put(housing, totalWorldTime = world.func_82737_E())) != null) {
            this.times.add(totalWorldTime - prevTime);
            double d = (double)this.times.sum() / (double)this.times.size();
        }
        this.performEffect(genome, storedData, housing, world.field_73012_v, world, housing.getCoordinates(), beeHousingModifier, beeModeModifier, settings);
        return storedData;
    }

    public abstract void performEffect(@Nonnull IBeeGenome var1, @Nonnull IEffectData var2, @Nonnull IBeeHousing var3, @Nonnull Random var4, World var5, BlockPos var6, IBeeModifier var7, IBeeModifier var8, IEffectSettingsHolder var9);

    @Override
    public float getCooldown(@Nonnull IBeeGenome genome, Random random) {
        float base;
        float speed = genome.getSpeed();
        float result = base = this.baseTicksBetweenProcessing / speed;
        if (this.chanceOfProcessing < 1.0f) {
            while (random.nextFloat() > this.chanceOfProcessing) {
                result += base;
            }
        }
        return result;
    }
}

