/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.util;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import org.embeddedt.vintagefix.util.CachedResourcePath;

public class FolderPackCache {
    private final ObjectOpenHashSet<CachedResourcePath> cachedPaths = new ObjectOpenHashSet();

    public FolderPackCache(File folderPath) {
        this.explore(folderPath, "");
        this.cachedPaths.trim();
    }

    private void explore(File folder, String path) {
        File[] theFiles = folder.listFiles();
        if (theFiles == null) {
            return;
        }
        for (File f : theFiles) {
            String myPath = (path.isEmpty() ? "" : path + "/") + f.getName();
            CachedResourcePath cPath = new CachedResourcePath(myPath, true);
            this.cachedPaths.add((Object)cPath);
            if (!f.isDirectory()) continue;
            this.explore(f, myPath);
        }
    }

    public boolean hasPath(String p) {
        return this.cachedPaths.contains((Object)new CachedResourcePath(p, false));
    }
}

