/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.fastmap;

import com.google.common.base.Preconditions;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.math.MathHelper;
import org.embeddedt.vintagefix.fastmap.FastMapKey;

public class BinaryFastMapKey<T extends Comparable<T>>
extends FastMapKey<T> {
    private final byte firstBitInValue;
    private final byte firstBitAfterValue;

    private static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public BinaryFastMapKey(IProperty<T> property, int mapFactor) {
        super(property);
        Preconditions.checkArgument((boolean)BinaryFastMapKey.isPowerOfTwo(mapFactor));
        int addedFactor = MathHelper.func_151236_b((int)this.numValues());
        Preconditions.checkState((this.numValues() <= addedFactor ? 1 : 0) != 0);
        Preconditions.checkState((addedFactor < 2 * this.numValues() ? 1 : 0) != 0);
        int setBitInBaseFactor = MathHelper.func_151239_c((int)mapFactor);
        int setBitInAddedFactor = MathHelper.func_151239_c((int)addedFactor);
        Preconditions.checkState((setBitInBaseFactor + setBitInAddedFactor <= 31 ? 1 : 0) != 0);
        this.firstBitInValue = (byte)setBitInBaseFactor;
        this.firstBitAfterValue = (byte)(setBitInBaseFactor + setBitInAddedFactor);
    }

    @Override
    public T getValue(int mapIndex) {
        int clearAbove = mapIndex & this.lowestNBits(this.firstBitAfterValue);
        return this.byInternalIndex(clearAbove >>> this.firstBitInValue);
    }

    @Override
    public int replaceIn(int mapIndex, T newValue) {
        int newPartialIndex = this.toPartialMapIndex((Comparable<?>)newValue);
        if (newPartialIndex < 0) {
            return -1;
        }
        int keepMask = ~this.lowestNBits(this.firstBitAfterValue) | this.lowestNBits(this.firstBitInValue);
        return keepMask & mapIndex | newPartialIndex;
    }

    @Override
    public int toPartialMapIndex(Comparable<?> value) {
        int internalIndex = this.getInternalIndex(value);
        if (internalIndex < 0 || internalIndex >= this.numValues()) {
            return -1;
        }
        return internalIndex << this.firstBitInValue;
    }

    @Override
    public int getFactorToNext() {
        return 1 << this.firstBitAfterValue - this.firstBitInValue;
    }

    private int lowestNBits(byte n) {
        if (n >= 32) {
            return -1;
        }
        return (1 << n) - 1;
    }
}

