/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.dynamicresources;

import com.google.common.base.Stopwatch;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ItemModelMesherForge;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.core.MixinConfigPlugin;
import org.embeddedt.vintagefix.dynamicresources.model.DynamicBakedModelProvider;

public class ItemBakeThread
extends Thread {
    private static volatile ItemBakeThread bakeThread = null;
    private final LinkedList<ResourceLocation> locations;
    private final DynamicBakedModelProvider myProvider;
    volatile boolean stop = false;

    public static void restartBake() {
        ItemBakeThread.stopAndJoin();
        if (FMLClientHandler.instance().hasError() || Minecraft.func_71410_x().field_71441_e != null || !MixinConfigPlugin.isMixinClassApplied("mixin.dynamic_resources.background_item_bake.BakeMixin")) {
            return;
        }
        ItemModelMesherForge immf = (ItemModelMesherForge)Minecraft.func_71410_x().func_175599_af().func_175037_a();
        Map theMap = (Map)ObfuscationReflectionHelper.getPrivateValue(ItemModelMesherForge.class, (Object)immf, (String)"locations");
        ArrayList<ModelResourceLocation> theList = new ArrayList<ModelResourceLocation>();
        for (Int2ObjectMap innerMap : theMap.values()) {
            theList.addAll((Collection<ModelResourceLocation>)innerMap.values());
        }
        bakeThread = new ItemBakeThread(theList);
        bakeThread.start();
    }

    ItemBakeThread(List<ModelResourceLocation> locations) {
        this.locations = new LinkedList<ModelResourceLocation>(locations);
        this.myProvider = DynamicBakedModelProvider.instance;
        this.setName("VintageFix item baking thread");
        this.setPriority(1);
    }

    @Override
    public void run() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        int numBaked = 0;
        int total = this.locations.size();
        long lastPrint = System.nanoTime();
        long printDelta = TimeUnit.MILLISECONDS.toNanos(5000L);
        VintageFix.LOGGER.info("Baking {} models in background", (Object)total);
        ObjectOpenHashSet processedLocations = new ObjectOpenHashSet();
        while (!this.stop && !this.locations.isEmpty()) {
            ResourceLocation location = this.locations.removeFirst();
            processedLocations.add(location);
            ModelResourceLocation modelKey = location instanceof ModelResourceLocation ? (ModelResourceLocation)location : ModelLoader.getInventoryVariant((String)location.toString());
            try {
                IBakedModel theModel = this.myProvider.getObject(modelKey);
                if (theModel != null) {
                    this.myProvider.putObject(modelKey, theModel);
                }
            }
            catch (Throwable e) {
                VintageFix.LOGGER.error("Error baking {}: {}", (Object)location, (Object)e);
            }
            if (++numBaked % 10 != 0 || System.nanoTime() - lastPrint < printDelta) continue;
            lastPrint = System.nanoTime();
            VintageFix.LOGGER.info(String.format("Item baking at %.02f%%", Float.valueOf((float)numBaked / (float)total * 100.0f)));
        }
        stopwatch.stop();
        if (!this.stop) {
            VintageFix.LOGGER.info("Item baking finished in {}", (Object)stopwatch);
        }
    }

    public static void stopAndJoin() {
        if (bakeThread != null) {
            ItemBakeThread.bakeThread.stop = true;
            while (bakeThread.isAlive()) {
                try {
                    bakeThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            bakeThread = null;
        }
    }

    public static class ReloadListener
    implements ISelectiveResourceReloadListener {
        public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
            if (resourcePredicate.test((IResourceType)VanillaResourceType.MODELS)) {
                ItemBakeThread.restartBake();
            }
        }
    }
}

