/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.rftoolscontrol.items.ProgramCardItem;
import mcjty.rftoolscontrol.items.craftingcard.CraftingCardItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketItemNBTToServer
implements IMessage {
    private NBTTagCompound tagCompound;

    public void fromBytes(ByteBuf buf) {
        this.tagCompound = NetworkTools.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writeTag((ByteBuf)buf, (NBTTagCompound)this.tagCompound);
    }

    public PacketItemNBTToServer() {
    }

    public PacketItemNBTToServer(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketItemNBTToServer(NBTTagCompound tagCompound) {
        this.tagCompound = tagCompound;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP player = ctx.getSender();
            ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
            if (heldItem.func_190926_b()) {
                return;
            }
            if (heldItem.func_77973_b() instanceof ProgramCardItem) {
                heldItem.func_77982_d(this.tagCompound);
            } else if (heldItem.func_77973_b() instanceof CraftingCardItem) {
                heldItem.func_77982_d(this.tagCompound);
            }
        });
        ctx.setPacketHandled(true);
    }
}

