/*
 * Decompiled with CFR 0.152.
 */
package magicbees.integration.thaumcraft.effects;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import magicbees.elec332.corerepack.compat.forestry.EffectData;
import magicbees.elec332.corerepack.compat.forestry.allele.AlleleEffectThrottled;
import magicbees.integration.thaumcraft.IntegrationThaumcraft;
import magicbees.integration.thaumcraft.util.AuraHelper;
import net.minecraft.util.ResourceLocation;

public class AlleleEffectNexus
extends AlleleEffectThrottled {
    public AlleleEffectNexus(ResourceLocation rl) {
        super(rl);
        this.setRequiresWorkingQueen();
        this.setThrottle(15);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        AuraHelper.handleRandomChunk(genome, housing, auraChunk -> {
            float max = Math.min((float)IntegrationThaumcraft.MAX_AURA, (float)auraChunk.getBase() * 1.2f);
            float newV = Math.min((float)((double)auraChunk.getVis() + 0.18 * housing.getWorldObj().field_73012_v.nextDouble()), max);
            auraChunk.setVis(newV);
        });
        storedData.setInteger(0, 0);
        return storedData;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null || !(storedData instanceof EffectData)) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }
}

