/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IHiveDrop;
import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.apiculture.hives.IHiveGen;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import magicbees.bees.EnumBeeSpecies;
import magicbees.bees.EnumHiveGen;
import magicbees.elec332.corerepack.compat.forestry.ForestryAlleles;
import magicbees.elec332.corerepack.compat.forestry.bee.HiveDrop;
import magicbees.elec332.corerepack.compat.forestry.bee.IHiveEnum;
import magicbees.init.BlockRegister;
import magicbees.init.ItemRegister;
import magicbees.item.types.EnumCombType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public enum EnumBeeHives implements IHiveEnum
{
    CURIOUS(EnumBeeSpecies.MYSTICAL, 12, false, new EnumHiveGen[]{EnumHiveGen.CURIOUS}){

        @Override
        public void registerDrops() {
            this.addDefaultDrops(15);
        }
    }
    ,
    UNUSUAL(EnumBeeSpecies.UNUSUAL, 12, false, new EnumHiveGen[]{EnumHiveGen.UNUSUAL}){

        @Override
        public void registerDrops() {
            this.addDefaultDrops(15);
        }
    }
    ,
    RESONANT(EnumBeeSpecies.SORCEROUS, 12, false, new EnumHiveGen[]{EnumHiveGen.RESONANT}){

        @Override
        public void registerDrops() {
            this.addDefaultDrops(20);
        }
    }
    ,
    DEEP(EnumBeeSpecies.ATTUNED, 4, true, new EnumHiveGen[]{EnumHiveGen.DEEP}){

        @Override
        public void registerDrops() {
            this.addDefaultDrops(20);
        }
    }
    ,
    INFERNAL(EnumBeeSpecies.INFERNAL, 15, true, new EnumHiveGen[]{EnumHiveGen.INFERNAL, EnumHiveGen.INFERNAL_OVERWORLD}){

        @Override
        public void registerDrops() {
            ItemStack[] combs = new ItemStack[]{ItemRegister.combItem.getStackFromType(EnumCombType.MOLTEN), new ItemStack(Items.field_151114_aO, 6)};
            this.addDrop(new IHiveDrop[]{new HiveDrop(this.getBeeType(), (double)0.8f, combs).setIgnobleChance(0.5)});
            this.addDrop(new IHiveDrop[]{new HiveDrop(BeeManager.beeRoot.templateAsGenome(EnumBeeSpecies.getForestrySpeciesTemplate("Steadfast")), (double)0.03f, combs)});
        }
    }
    ,
    OBLIVION(EnumBeeSpecies.OBLIVION, 7, true, new EnumHiveGen[]{EnumHiveGen.OBLIVION, EnumHiveGen.OBLIVION_OVERWORLD}){

        @Override
        public void registerDrops() {
            ItemStack[] combs = new ItemStack[]{ItemRegister.combItem.getStackFromType(EnumCombType.FORGOTTEN), new ItemStack(Items.field_151079_bi)};
            this.addDrop(new IHiveDrop[]{new HiveDrop(this.getBeeType(), (double)0.8f, combs)});
            this.addDrop(new IHiveDrop[]{new HiveDrop(BeeManager.beeRoot.templateAsGenome(EnumBeeSpecies.getForestrySpeciesTemplate("Steadfast")), (double)0.09f, combs)});
        }
    };

    private final EnumBeeSpecies bee;
    private final boolean ignoreClimate;
    private final int light;
    private final List<IHiveDescription> genTypes;
    private static ItemStack comb;
    private static IHiveDrop valiantDrop;

    private EnumBeeHives(EnumBeeSpecies beeType, int light, boolean ignoreClimate, EnumHiveGen ... genTypes) {
        this.bee = beeType;
        this.ignoreClimate = ignoreClimate;
        this.light = light;
        this.genTypes = Lists.newArrayList((Object[])((Object[])Preconditions.checkNotNull((Object)genTypes))).stream().map(x$0 -> new Desc((EnumHiveGen)((Object)x$0))).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public IHiveDescription getHiveDescription() {
        return this.genTypes.get(0);
    }

    @Override
    public String getBeeUid() {
        return this.bee.getUid();
    }

    @Override
    @Nonnull
    public List<IHiveDescription> getHiveDescriptions() {
        return this.genTypes;
    }

    @Override
    public String getUid(IHiveDescription desc) {
        return "magicbees.hive." + ((Desc)desc).gen.name();
    }

    @Override
    public int getMeta() {
        return this.ordinal();
    }

    @Override
    public boolean showInTab() {
        return true;
    }

    @Override
    public int getLight() {
        return this.light;
    }

    public abstract void registerDrops();

    protected final EnumBeeSpecies getBeeType() {
        return this.bee;
    }

    protected void addDefaultDrops(int rr) {
        this.addDrop(new IHiveDrop[]{new HiveDrop(this.bee, (double)0.8f, EnumBeeHives.getComb()).setIgnobleChance(0.7f)});
        this.addDrop(new IHiveDrop[]{new HiveDrop(EnumBeeHives.addRainResist(this.bee), (double)((float)rr / 100.0f), EnumBeeHives.getComb())});
        this.addDrop(EnumBeeHives.getValiantDrop());
    }

    private static IHiveDrop getValiantDrop() {
        if (valiantDrop == null) {
            valiantDrop = new HiveDrop(EnumBeeHives.addRainResist(EnumBeeSpecies.getForestrySpeciesTemplate("Valiant")), 0.05, comb);
        }
        return valiantDrop;
    }

    private static ItemStack getComb() {
        if (comb == null) {
            comb = ItemRegister.combItem.getStackFromType(EnumCombType.MUNDANE);
        }
        return comb;
    }

    private static IBeeGenome addRainResist(IAllele[] alleles) {
        IAllele[] ret = (IAllele[])alleles.clone();
        ret[EnumBeeChromosome.TOLERATES_RAIN.ordinal()] = ForestryAlleles.TRUE_RECESSIVE;
        return BeeManager.beeRoot.templateAsGenome(ret);
    }

    private static IBeeGenome addRainResist(EnumBeeSpecies species) {
        return EnumBeeHives.addRainResist(species.getAlleles());
    }

    private class Desc
    implements IHiveDescription {
        private final EnumHiveGen gen;

        private Desc(EnumHiveGen gen) {
            this.gen = gen;
        }

        @Nonnull
        public IHiveGen getHiveGen() {
            return this.gen.hiveGen;
        }

        @Nonnull
        public IBlockState getBlockState() {
            return BlockRegister.hiveBlock.getStateFromHive(EnumBeeHives.this);
        }

        public boolean isGoodBiome(@Nonnull Biome biome) {
            Set types = BiomeDictionary.getTypes((Biome)biome);
            for (BiomeDictionary.Type type : this.gen.biomes) {
                if (!types.contains(type)) continue;
                return true;
            }
            return false;
        }

        public boolean isGoodHumidity(@Nonnull EnumHumidity humidity) {
            if (EnumBeeHives.this.ignoreClimate) {
                return true;
            }
            EnumHumidity idealHumidity = EnumBeeHives.this.bee.getSpecies().getHumidity();
            EnumTolerance humidityTolerance = ((IBeeGenome)EnumBeeHives.this.bee.getGenome()).getToleranceHumid();
            return AlleleManager.climateHelper.isWithinLimits(humidity, idealHumidity, humidityTolerance);
        }

        public boolean isGoodTemperature(@Nonnull EnumTemperature temperature) {
            if (EnumBeeHives.this.ignoreClimate) {
                return true;
            }
            EnumTemperature idealTemperature = EnumBeeHives.this.bee.getSpecies().getTemperature();
            EnumTolerance temperatureTolerance = ((IBeeGenome)EnumBeeHives.this.bee.getGenome()).getToleranceTemp();
            return AlleleManager.climateHelper.isWithinLimits(temperature, idealTemperature, temperatureTolerance);
        }

        public float getGenChance() {
            return this.gen.chance;
        }

        public void postGen(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos blockPos) {
            this.gen.postGen(world, random, blockPos);
        }
    }
}

