/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowlib.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class ClasspathUtils {
    public static void addURLToClasspath(URL url) {
        try {
            URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addURL.setAccessible(true);
            addURL.invoke((Object)urlClassLoader, url);
        }
        catch (NoSuchMethodException e) {
            System.err.println("URLClassLoader#addURL did not exist! This is a problem, report this immediately!");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.err.println("Could not access URLClassLoader#addURL! This is a problem, report this immediately!");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            System.err.println("URLClassLoader#addURL was invoked on the wrong target! This is a problem, report this immediately!");
            e.printStackTrace();
        }
    }

    public static void addFileToClasspath(File file) {
        try {
            ClasspathUtils.addURLToClasspath(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static File readFileFromClasspath(String name) {
        try {
            File tempFile = File.createTempFile("ShadowLibClasspathFile", ".tmp");
            InputStream inputStream = ClasspathUtils.class.getResourceAsStream(name);
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                fileOutputStream.write(bytes, 0, read);
            }
            return tempFile;
        }
        catch (IOException e) {
            System.err.println("Error creating the temp file!");
            e.printStackTrace();
            return null;
        }
    }
}

