/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client.gui.elements;

public interface ILocationLookup {
    public int getX();

    public int getY();

    public int getWidth();

    public int getHeight();

    public static ILocationLookup get(final int x, final int y, final int width, final int height) {
        return new ILocationLookup(){

            @Override
            public int getX() {
                return x;
            }

            @Override
            public int getY() {
                return y;
            }

            @Override
            public int getWidth() {
                return width;
            }

            @Override
            public int getHeight() {
                return height;
            }
        };
    }

    default public ILocationLookup below(final int width, final int height) {
        final ILocationLookup parent = this;
        return new ILocationLookup(){

            @Override
            public int getX() {
                return parent.getX();
            }

            @Override
            public int getY() {
                return parent.getY() + parent.getHeight();
            }

            @Override
            public int getWidth() {
                return width;
            }

            @Override
            public int getHeight() {
                return height;
            }
        };
    }

    default public ILocationLookup right(final int width, final int height) {
        final ILocationLookup parent = this;
        return new ILocationLookup(){

            @Override
            public int getX() {
                return parent.getX() + parent.getWidth();
            }

            @Override
            public int getY() {
                return parent.getY();
            }

            @Override
            public int getWidth() {
                return width;
            }

            @Override
            public int getHeight() {
                return height;
            }
        };
    }

    default public ILocationLookup offset(final int x, final int y) {
        final ILocationLookup parent = this;
        return new ILocationLookup(){

            @Override
            public int getX() {
                return x + parent.getX();
            }

            @Override
            public int getY() {
                return y + parent.getX();
            }

            @Override
            public int getWidth() {
                return parent.getWidth();
            }

            @Override
            public int getHeight() {
                return parent.getHeight();
            }
        };
    }
}

