/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.TileFluidHandler;
import net.minecraftforge.items.ItemStackHandler;
import rustic.common.crafting.ICondenserRecipe;
import rustic.common.inventory.ExternalItemHandler;

public abstract class TileEntityCondenserBase
extends TileFluidHandler
implements ITickable {
    public static final int SLOT_RESULT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_BOTTLE = 2;
    public static final int SLOT_INGREDIENTS_START = 3;
    public static final int CAPACITY = 8000;
    protected ItemStackHandler internalStackHandler = new ItemStackHandler(this.getInternalSize()){

        protected void onContentsChanged(int slot) {
            IBlockState state = TileEntityCondenserBase.this.field_145850_b.func_180495_p(TileEntityCondenserBase.this.field_174879_c);
            TileEntityCondenserBase.this.field_145850_b.func_175641_c(TileEntityCondenserBase.this.field_174879_c, TileEntityCondenserBase.this.func_145838_q(), 1, 0);
            TileEntityCondenserBase.this.field_145850_b.func_184138_a(TileEntityCondenserBase.this.field_174879_c, state, state, 3);
            TileEntityCondenserBase.this.field_145850_b.func_175685_c(TileEntityCondenserBase.this.field_174879_c, TileEntityCondenserBase.this.func_145838_q(), true);
            TileEntityCondenserBase.this.func_70296_d();
            TileEntityCondenserBase.this.hasContentChanged = true;
        }
    };
    protected ExternalItemHandler externalStackHandler = new ExternalItemHandler(this.internalStackHandler){

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot == 1 && !TileEntityFurnace.func_145954_b((ItemStack)stack)) {
                return stack;
            }
            if (slot == 2 && TileEntityFurnace.func_145954_b((ItemStack)stack)) {
                return stack;
            }
            if (slot == 0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    protected ICondenserRecipe currentRecipe;
    protected boolean hasContentChanged;
    public int condenserBurnTime;
    public int currentItemBurnTime;
    public int brewTime;
    public int totalBrewTime;

    protected abstract int getInternalSize();

    public TileEntityCondenserBase() {
        this.tank = new FluidTank(8000){

            protected void onContentsChanged() {
                TileEntityCondenserBase.this.func_70296_d();
                TileEntityCondenserBase.this.hasContentChanged = true;
            }
        };
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(true);
        this.tank.setCanDrain(true);
        this.currentRecipe = null;
        this.hasContentChanged = true;
    }

    public abstract String getName();

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public int getAmount() {
        return this.tank.getFluidAmount();
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public Fluid getFluid() {
        if (this.tank.getFluid() != null) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public void func_73660_a() {
        boolean isBrewing = this.canBrew();
        boolean hasRecipe = isBrewing && this.hasValidRecipe();
        if (this.burnFuel(isBrewing && hasRecipe) && isBrewing && hasRecipe) {
            ++this.brewTime;
            this.renderParticles();
            if (this.brewTime >= this.currentRecipe.getTime()) {
                this.brewTime = 0;
                if (!this.field_145850_b.field_72995_K) {
                    this.brew();
                }
            }
        } else if (this.brewTime > 0) {
            this.brewTime = MathHelper.func_76125_a((int)(this.brewTime - 2), (int)0, (int)this.totalBrewTime);
        }
    }

    protected abstract boolean canBrew();

    protected boolean hasValidRecipe() {
        if (this.condenserBurnTime <= 0 && this.internalStackHandler.getStackInSlot(1).func_190926_b()) {
            return false;
        }
        if (this.hasContentChanged) {
            this.refreshCurrentRecipe();
        }
        if (this.currentRecipe == null) {
            return false;
        }
        if (this.getAmount() < this.currentRecipe.getFluid().amount) {
            return false;
        }
        return this.internalStackHandler.insertItem(0, this.currentRecipe.getResult(), true).func_190926_b();
    }

    protected abstract void refreshCurrentRecipe();

    private boolean burnFuel(boolean consumeNewFuel) {
        if (this.condenserBurnTime > 0) {
            --this.condenserBurnTime;
            return true;
        }
        ItemStack fuelStack = this.internalStackHandler.getStackInSlot(1);
        if (consumeNewFuel && !fuelStack.func_190926_b()) {
            this.currentItemBurnTime = this.condenserBurnTime = TileEntityFurnace.func_145952_a((ItemStack)fuelStack);
            if (!this.field_145850_b.field_72995_K) {
                Item fuelItem = fuelStack.func_77973_b();
                fuelStack.func_190918_g(1);
                if (fuelStack.func_190926_b()) {
                    this.internalStackHandler.setStackInSlot(1, fuelItem.getContainerItem(fuelStack));
                }
            }
            return true;
        }
        return false;
    }

    public boolean isBurning() {
        return this.condenserBurnTime > 0;
    }

    protected abstract void renderParticles();

    protected abstract void brew();

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("items")) {
            this.internalStackHandler.deserializeNBT((NBTTagCompound)tag.func_74781_a("items"));
        }
        this.condenserBurnTime = tag.func_74762_e("BurnTime");
        this.brewTime = tag.func_74762_e("BrewTime");
        this.totalBrewTime = tag.func_74762_e("BrewTimeTotal");
        this.currentItemBurnTime = tag.func_74762_e("ItemBurnTime");
        this.hasContentChanged = true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74782_a("items", (NBTBase)this.internalStackHandler.serializeNBT());
        tag.func_74768_a("BurnTime", (int)((short)this.condenserBurnTime));
        tag.func_74768_a("BrewTime", (int)((short)this.brewTime));
        tag.func_74768_a("BrewTimeTotal", (int)((short)this.totalBrewTime));
        tag.func_74768_a("ItemBurnTime", this.currentItemBurnTime);
        return tag;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.func_70296_d();
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        this.func_145843_s();
        if (this.internalStackHandler != null && !world.field_72995_K) {
            for (int i = 0; i < this.internalStackHandler.getSlots(); ++i) {
                if (this.internalStackHandler.getStackInSlot(i) == null) continue;
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.internalStackHandler.getStackInSlot(i));
            }
        }
        world.func_175690_a(pos, null);
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem != ItemStack.field_190927_a) {
            boolean didFill;
            if ((FluidUtil.getFluidHandler((ItemStack)heldItem) != null || heldItem.func_77973_b() instanceof ItemBucket || heldItem.func_77973_b() instanceof UniversalBucket) && (didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side))))) {
                this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
                this.func_145831_w().func_184138_a(pos, state, state, 3);
                this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
                this.func_70296_d();
                return true;
            }
        } else if (player.func_70093_af() && this.tank.getFluidAmount() > 0) {
            FluidStack drained = this.tank.drainInternal(8000, true);
            SoundEvent soundevent = drained.getFluid().getEmptySound(drained);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
            this.func_145831_w().func_184138_a(pos, state, state, 3);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.func_70296_d();
            return true;
        }
        return false;
    }
}

