/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.common.blocks.BlockBase;

public class BlockWoodLantern
extends BlockBase {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(@Nullable EnumFacing p_apply_1_) {
            return p_apply_1_ != EnumFacing.DOWN;
        }
    });
    protected static final AxisAlignedBB LANTERN_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    protected static final AxisAlignedBB LANTERN_NORTH_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 1.0);
    protected static final AxisAlignedBB LANTERN_SOUTH_AABB = new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 0.75);
    protected static final AxisAlignedBB LANTERN_WEST_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 0.75);
    protected static final AxisAlignedBB LANTERN_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 0.75);

    public BlockWoodLantern() {
        this("lantern_wood");
    }

    public BlockWoodLantern(String name) {
        this(Material.field_151575_d, name, true);
    }

    public BlockWoodLantern(Material mat, String name, boolean register) {
        super(mat, name, register);
        this.func_149711_c(1.0f);
        this.func_149715_a(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        this.func_149672_a(SoundType.field_185848_a);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return LANTERN_EAST_AABB;
            }
            case WEST: {
                return LANTERN_WEST_AABB;
            }
            case SOUTH: {
                return LANTERN_SOUTH_AABB;
            }
            case NORTH: {
                return LANTERN_NORTH_AABB;
            }
        }
        return LANTERN_AABB;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!this.canPlaceAt(worldIn, pos, facing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        if (facing.func_176740_k().func_176722_c()) {
            return worldIn.isSideSolid(blockpos, facing, true);
        }
        IBlockState state = worldIn.func_180495_p(blockpos);
        BlockFaceShape faceShape = state.func_193401_d((IBlockAccess)worldIn, blockpos, facing);
        if (faceShape == BlockFaceShape.SOLID || faceShape == BlockFaceShape.CENTER || faceShape == BlockFaceShape.CENTER_BIG || faceShape == BlockFaceShape.CENTER_SMALL) {
            return true;
        }
        if (facing == EnumFacing.UP) {
            return state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)worldIn, blockpos);
        }
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(worldIn, pos, facing)) {
            if (facing == EnumFacing.DOWN) {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
            }
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!worldIn.isSideSolid(pos.func_177972_a(enumfacing.func_176734_d()), enumfacing, true)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.onNeighborChangeInternal(worldIn, pos, state);
    }

    protected boolean onNeighborChangeInternal(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.checkForDrop(worldIn, pos, state)) {
            return true;
        }
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing.Axis axis = enumfacing.func_176740_k();
        boolean flag = false;
        if (axis.func_176722_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) {
                flag = true;
            }
        } else if (!this.canPlaceAt(worldIn, pos, EnumFacing.UP) && !this.canPlaceAt(worldIn, pos, EnumFacing.DOWN)) {
            flag = true;
        }
        if (flag) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return true;
        }
        return false;
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (this.canPlaceAt(worldIn, pos, facing)) {
                return true;
            }
            if (facing == EnumFacing.UP && this.canPlaceAt(worldIn, pos, EnumFacing.DOWN)) {
                return true;
            }
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.5 + (double)rand.nextFloat() * 0.375;
        double d2 = (double)pos.func_177952_p() + 0.5;
        double rx = rand.nextFloat() * 0.6f - 0.3f;
        double rz = rand.nextFloat() * 0.6f - 0.3f;
        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + rx, d1, d2 + rz, 0.0, 0.0, 0.0, new int[0]);
        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + rx, d1, d2 + rz, 0.0, 0.0, 0.0, new int[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing facing = rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING));
        if (facing == EnumFacing.DOWN) {
            facing = EnumFacing.UP;
        }
        return state.func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        switch (meta) {
            case 1: {
                return iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
            }
            case 2: {
                return iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
            }
            case 3: {
                return iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
            }
            case 4: {
                return iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
            }
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return 1;
            }
            case WEST: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
            case NORTH: {
                return 4;
            }
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return side.func_176740_k().func_176720_b() ? BlockFaceShape.CENTER_BIG : BlockFaceShape.UNDEFINED;
    }
}

