/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.decoration.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.block.BlockMod;
import vazkii.arl.item.ItemModBlock;
import vazkii.quark.automation.feature.PistonsMoveTEs;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.decoration.feature.Rope;

public class BlockRope
extends BlockMod
implements IQuarkBlock {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);

    public BlockRope() {
        super("rope", Material.field_151580_n, new String[0]);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public ItemBlock createItemBlock(ResourceLocation res) {
        return new ItemModBlock((Block)this, res){

            public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
                return world.func_180495_p(pos).func_177230_c() == BlockRope.this;
            }
        };
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            ItemStack stack = playerIn.func_184586_b(hand);
            if (stack.func_77973_b() == Item.func_150898_a((Block)this) && !playerIn.func_70093_af()) {
                if (this.pullDown(worldIn, pos)) {
                    if (!playerIn.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    worldIn.func_184133_a(null, pos, this.field_149762_H.func_185841_e(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                    return true;
                }
            } else {
                if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                    return FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (World)worldIn, (BlockPos)this.getBottomPos(worldIn, pos), (EnumFacing)EnumFacing.UP);
                }
                if (stack.func_77973_b() == Items.field_151069_bo) {
                    BlockPos bottomPos = this.getBottomPos(worldIn, pos);
                    IBlockState stateAt = worldIn.func_180495_p(bottomPos);
                    if (stateAt.func_185904_a() == Material.field_151586_h) {
                        worldIn.func_184148_a(playerIn, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                        stack.func_190918_g(1);
                        ItemStack bottleStack = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
                        playerIn.func_71029_a(StatList.func_188057_b((Item)stack.func_77973_b()));
                        if (stack.func_190926_b()) {
                            playerIn.func_184611_a(hand, bottleStack);
                        } else if (!playerIn.field_71071_by.func_70441_a(bottleStack)) {
                            playerIn.func_71019_a(bottleStack, false);
                        }
                        return true;
                    }
                    return false;
                }
                if (this.pullUp(worldIn, pos)) {
                    if (!playerIn.func_184812_l_() && !playerIn.func_191521_c(new ItemStack((Block)this))) {
                        playerIn.func_71019_a(new ItemStack((Block)this), false);
                    }
                    worldIn.func_184133_a(null, pos, this.field_149762_H.func_185845_c(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                    return true;
                }
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public boolean pullUp(World world, BlockPos pos) {
        IBlockState state;
        BlockPos basePos = pos;
        while ((state = world.func_180495_p(pos = pos.func_177977_b())).func_177230_c() == this) {
        }
        BlockPos ropePos = pos.func_177984_a();
        if (ropePos.equals((Object)basePos)) {
            return false;
        }
        world.func_175698_g(ropePos);
        this.moveBlock(world, pos, ropePos);
        return true;
    }

    public boolean pullDown(World world, BlockPos pos) {
        Block block;
        boolean endRope = false;
        boolean wasAirAtEnd = false;
        while (true) {
            IBlockState state;
            if ((block = (state = world.func_180495_p(pos = pos.func_177977_b())).func_177230_c()) == this) continue;
            if (endRope) break;
            endRope = true;
            wasAirAtEnd = world.func_175623_d(pos);
        }
        boolean can = wasAirAtEnd || world.func_175623_d(pos) || block.func_176200_f((IBlockAccess)world, pos);
        if (can) {
            BlockPos ropePos = pos.func_177984_a();
            this.moveBlock(world, ropePos, pos);
            IBlockState ropePosState = world.func_180495_p(ropePos);
            Block ropePosBlock = ropePosState.func_177230_c();
            if (world.func_175623_d(ropePos) || ropePosBlock.func_176200_f((IBlockAccess)world, ropePos)) {
                world.func_175656_a(ropePos, this.func_176223_P());
                return true;
            }
        }
        return false;
    }

    private BlockPos getBottomPos(World worldIn, BlockPos pos) {
        BlockRope block = this;
        while (block == this) {
            pos = pos.func_177977_b();
            IBlockState state = worldIn.func_180495_p(pos);
            block = state.func_177230_c();
        }
        return pos;
    }

    private void moveBlock(World world, BlockPos srcPos, BlockPos dstPos) {
        IBlockState state = world.func_180495_p(srcPos);
        Block block = state.func_177230_c();
        if (state.func_185887_b(world, srcPos) == -1.0f || !block.func_176196_c(world, dstPos) || block.isAir(state, (IBlockAccess)world, srcPos) || state.func_185905_o() != EnumPushReaction.NORMAL || block == Blocks.field_150343_Z) {
            return;
        }
        TileEntity tile = world.func_175625_s(srcPos);
        if (tile != null) {
            if (Rope.forceEnableMoveTEs ? PistonsMoveTEs.shouldMoveTE(state) : PistonsMoveTEs.shouldMoveTE(true, state)) {
                return;
            }
            tile.func_145843_s();
        }
        world.func_175698_g(srcPos);
        world.func_175656_a(dstPos, state);
        if (tile != null) {
            tile.func_174878_a(dstPos);
            TileEntity target = TileEntity.func_190200_a((World)world, (NBTTagCompound)tile.func_189515_b(new NBTTagCompound()));
            if (target != null) {
                world.func_175690_a(dstPos, target);
                target.func_145836_u();
                if (block instanceof BlockChest) {
                    ((BlockChest)block).func_176455_e(world, dstPos, state);
                }
            }
        }
        world.func_175685_c(dstPos, block, true);
    }

    public boolean func_176196_c(World worldIn, @Nonnull BlockPos pos) {
        BlockPos posUp = pos.func_177984_a();
        IBlockState stateUp = worldIn.func_180495_p(posUp);
        BlockFaceShape shape = stateUp.func_193401_d((IBlockAccess)worldIn, posUp, EnumFacing.DOWN);
        return (shape == BlockFaceShape.SOLID || shape == BlockFaceShape.CENTER || shape == BlockFaceShape.CENTER_BIG) && !BlockRope.func_193384_b((Block)stateUp.func_177230_c());
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.func_176196_c(worldIn, pos)) {
            worldIn.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)worldIn.func_180495_p(pos)));
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 30;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.UNDEFINED : BlockFaceShape.CENTER;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

