/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.block;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.block.BlockMod;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.quark.automation.block.BlockRedstoneRandomizer;
import vazkii.quark.automation.tile.TileInductor;
import vazkii.quark.base.block.IQuarkBlock;

public class BlockRedstoneInductor
extends BlockMod
implements IQuarkBlock,
IBlockColorProvider {
    protected static final AxisAlignedBB REDSTONE_DIODE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyBool LOCKED = PropertyBool.func_177716_a((String)"locked");
    public static final PropertyInteger POWER = PropertyInteger.func_177719_a((String)"power", (int)0, (int)15);

    public BlockRedstoneInductor() {
        super("redstone_inductor", Material.field_151594_q, new String[0]);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LOCKED, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return (state, worldIn, pos, tintIndex) -> tintIndex == 1 ? BlockRedstoneWire.func_176337_b((int)((Integer)state.func_177229_b((IProperty)POWER))) : -1;
    }

    public IProperty[] getIgnoredProperties() {
        return new IProperty[]{POWER};
    }

    public IItemColor getItemColor() {
        return null;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileInductor();
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(this.getActiveSignal(worldIn, pos)));
    }

    private boolean shouldBeLocked(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing side1 = direction.func_176746_e();
        EnumFacing side2 = direction.func_176735_f();
        return this.getLockingPowerOnSide((IBlockAccess)worldIn, pos.func_177972_a(direction), direction) > 0 || this.getLockingPowerOnSide((IBlockAccess)worldIn, pos.func_177972_a(side1), side1) > 0 || this.getLockingPowerOnSide((IBlockAccess)worldIn, pos.func_177972_a(side2), side2) > 0;
    }

    protected int getLockingPowerOnSide(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (BlockRedstoneRepeater.func_185546_B((IBlockState)iblockstate)) {
            return worldIn.func_175627_a(pos, side);
        }
        return 0;
    }

    public void func_180645_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random random) {
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        boolean isLocked = this.isLocked(state);
        boolean willBeLocked = this.shouldBeLocked(worldIn, pos, state);
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)FACING);
        IBlockState finalState = state.func_177226_a((IProperty)LOCKED, (Comparable)Boolean.valueOf(willBeLocked));
        if (!isLocked || !willBeLocked) {
            int power = this.calculateInputStrength(worldIn, pos, state);
            TileEntity tile = worldIn.func_175625_s(pos);
            int prev = 0;
            if (tile instanceof TileInductor) {
                TileInductor inductor = (TileInductor)tile;
                prev = inductor.getOutputSignal();
                inductor.setOutputSignal(power);
            }
            state = state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(power));
            finalState = finalState.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(power));
            if (prev != power) {
                boolean shouldBePowered = this.shouldBePowered(worldIn, pos, state);
                boolean isPowered = this.isPowered(state);
                if (isPowered && !shouldBePowered) {
                    finalState = finalState.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
                } else if (!isPowered && shouldBePowered) {
                    finalState = finalState.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        worldIn.func_180501_a(pos, finalState, 3);
        worldIn.func_175695_a(pos.func_177967_a(side, -1), (Block)this, side);
    }

    protected int getActiveSignal(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        return tile instanceof TileInductor ? ((TileInductor)tile).getOutputSignal() : 0;
    }

    protected void updateState(World world, BlockPos pos) {
        world.func_180497_b(pos, (Block)this, 1, -1);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED, LOCKED, POWER});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 4 : 0) + ((Boolean)state.func_177229_b((IProperty)LOCKED) != false ? 8 : 0);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing face = EnumFacing.func_176731_b((int)(meta & 3));
        boolean powered = (meta & 4) != 0;
        boolean locked = (meta & 8) != 0;
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)face).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered)).func_177226_a((IProperty)LOCKED, (Comparable)Boolean.valueOf(locked));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return REDSTONE_DIODE_AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, @Nonnull BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) && super.func_176196_c(worldIn, pos);
    }

    public boolean canBlockStay(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP);
    }

    protected boolean isLocked(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LOCKED);
    }

    protected boolean isPowered(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!this.isPowered(blockState)) {
            return 0;
        }
        return blockState.func_177229_b((IProperty)FACING) == side ? this.getActiveSignal(blockAccess, pos) : 0;
    }

    public boolean getWeakChanges(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.canBlockStay(worldIn, pos)) {
            this.updateState(worldIn, pos);
        } else {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
        }
    }

    protected int calculateInputStrength(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing side1 = direction.func_176746_e();
        EnumFacing side2 = direction.func_176735_f();
        return Math.min(15, this.calculateInputStrength(worldIn, pos, direction) + this.calculateInputStrength(worldIn, pos, side1) + this.calculateInputStrength(worldIn, pos, side2));
    }

    protected int calculateInputStrength(World worldIn, BlockPos pos, EnumFacing side) {
        BlockPos blockpos = pos.func_177972_a(side);
        IBlockState state = worldIn.func_180495_p(blockpos);
        if (BlockRedstoneRepeater.func_185546_B((IBlockState)state)) {
            return 0;
        }
        int i = worldIn.func_175651_c(blockpos, side);
        if (i >= 15) {
            return i;
        }
        return Math.max(i, state.func_177230_c() == Blocks.field_150488_af ? (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O) : 0);
    }

    protected boolean shouldBePowered(World world, BlockPos pos, IBlockState currState) {
        return this.calculateInputStrength(world, pos, currState) > 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Nonnull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (this.shouldBePowered(worldIn, pos, state)) {
            worldIn.func_175684_a(pos, (Block)this, 1);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        BlockRedstoneRandomizer.notify((Block)this, worldIn, pos, state);
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        BlockRedstoneRandomizer.notify((Block)this, worldIn, pos, state);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean rotateBlock(World world, @Nonnull BlockPos pos, @Nonnull EnumFacing axis) {
        if (super.rotateBlock(world, pos, axis)) {
            IBlockState state = world.func_180495_p(pos);
            state = state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
            world.func_175656_a(pos, state);
            world.func_175684_a(pos, (Block)this, 1);
            return true;
        }
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

