/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.computers;

public class ArgHelper {
    private final Object[] args;

    public ArgHelper(Object[] args) {
        this.args = args;
    }

    public int count() {
        return this.args.length;
    }

    public Object checkAny(int index) {
        if (index >= this.count()) {
            throw new IllegalArgumentException("Expected argument at index: " + index);
        }
        return this.args[index];
    }

    public boolean checkBoolean(int index) {
        if (index >= this.count()) {
            throw new IllegalArgumentException("Expected boolean at index: " + index);
        }
        if (this.args[index] instanceof Boolean) {
            return (Boolean)this.args[index];
        }
        throw new IllegalArgumentException("Expected boolean at index: " + index);
    }

    public int checkInteger(int index) {
        if (index >= this.count()) {
            throw new IllegalArgumentException("Expected integer at index: " + index);
        }
        if (this.args[index] instanceof Double) {
            double d = (Double)this.args[index];
            return (int)d;
        }
        throw new IllegalArgumentException("Expected integer at index: " + index);
    }

    public double checkDouble(int index) {
        if (index >= this.count()) {
            throw new IllegalArgumentException("Expected double at index: " + index);
        }
        if (this.args[index] instanceof Double) {
            return (Double)this.args[index];
        }
        throw new IllegalArgumentException("Expected double at index: " + index);
    }

    public Object[] toArray() {
        return this.args;
    }
}

