/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.handlers;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thut.tech.common.blocks.lift.TileEntityLiftAccess;
import thut.tech.common.entity.EntityLift;
import thut.tech.common.handlers.ConfigHandler;

public class EnergyHandler {
    private static final ResourceLocation ENERGY = new ResourceLocation("thuttech", "energy");

    @SubscribeEvent
    public void onEntityCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLift) {
            event.addCapability(ENERGY, (ICapabilityProvider)new ProviderLift());
        }
    }

    @SubscribeEvent
    public void onTileCapabilityAttach(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileEntityLiftAccess) {
            event.addCapability(ENERGY, (ICapabilityProvider)new ProviderLiftController((TileEntityLiftAccess)((Object)event.getObject())));
        }
    }

    public static class ProviderLiftController
    implements ICapabilityProvider,
    IEnergyStorage {
        final TileEntityLiftAccess tile;
        IEnergyStorage lift = null;

        public ProviderLiftController(TileEntityLiftAccess tile) {
            this.tile = tile;
        }

        private void updateLift() {
            this.lift = this.tile.lift == null ? null : (IEnergyStorage)this.tile.lift.getCapability(CapabilityEnergy.ENERGY, null);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? CapabilityEnergy.ENERGY.cast((Object)this) : null);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.receiveEnergy(maxReceive, simulate);
            }
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.extractEnergy(maxExtract, simulate);
            }
            return 0;
        }

        public int getEnergyStored() {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.getEnergyStored();
            }
            return 0;
        }

        public int getMaxEnergyStored() {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.getMaxEnergyStored();
            }
            return 0;
        }

        public boolean canExtract() {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.canExtract();
            }
            return false;
        }

        public boolean canReceive() {
            this.updateLift();
            if (this.lift != null) {
                return this.lift.canReceive();
            }
            return false;
        }
    }

    public static class ProviderLift
    extends EnergyStorage
    implements ICapabilitySerializable<NBTTagCompound> {
        public ProviderLift() {
            super(ConfigHandler.maxLiftEnergy, ConfigHandler.maxLiftEnergy);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == CapabilityEnergy.ENERGY ? CapabilityEnergy.ENERGY.cast((Object)this) : null);
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("E", this.getEnergyStored());
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.energy = nbt.func_74762_e("E");
        }
    }
}

