/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.api.multipart;

import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.MultipartHelper;
import mcmultipart.api.slot.EnumEdgeSlot;
import mcmultipart.api.slot.SlotUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class MultipartRedstoneHelper {
    public static boolean canConnectRedstone(IMultipartContainer container, EnumFacing side) {
        return SlotUtil.viewContainer(container, i -> i.getPart().canConnectRedstone((IBlockAccess)i.getPartWorld(), i.getPartPos(), (IPartInfo)i, side), l -> l.stream().anyMatch(c -> c), false, true, side);
    }

    public static int getWeakPower(IMultipartContainer container, EnumFacing side) {
        return SlotUtil.viewContainer(container, i -> i.getPart().getWeakPower((IBlockAccess)i.getPartWorld(), i.getPartPos(), (IPartInfo)i, side), l -> (Integer)l.stream().max(Integer::compare).get(), 0, true, side);
    }

    public static int getStrongPower(IMultipartContainer container, EnumFacing side) {
        return SlotUtil.viewContainer(container, i -> i.getPart().getStrongPower((IBlockAccess)i.getPartWorld(), i.getPartPos(), (IPartInfo)i, side), l -> (Integer)l.stream().max(Integer::compare).get(), 0, true, side);
    }

    public static boolean canConnectRedstone(IMultipartContainer container, EnumEdgeSlot edge, EnumFacing side) {
        return SlotUtil.viewContainer(container, i -> i.getPart().canConnectRedstone((IBlockAccess)i.getPartWorld(), i.getPartPos(), (IPartInfo)i, side), l -> l.stream().anyMatch(c -> c), false, true, edge, side);
    }

    public static int getWeakPower(IMultipartContainer container, EnumEdgeSlot edge, EnumFacing side) {
        return SlotUtil.viewContainer(container, i -> i.getPart().getWeakPower((IBlockAccess)i.getPartWorld(), i.getPartPos(), (IPartInfo)i, side), l -> (Integer)l.stream().max(Integer::compare).get(), 0, true, edge, side);
    }

    public static int getStrongPower(IMultipartContainer container, EnumEdgeSlot edge, EnumFacing side) {
        return SlotUtil.viewContainer(container, i -> i.getPart().getStrongPower((IBlockAccess)i.getPartWorld(), i.getPartPos(), (IPartInfo)i, side), l -> (Integer)l.stream().max(Integer::compare).get(), 0, true, edge, side);
    }

    public static boolean canConnectRedstone(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return MultipartHelper.getContainer(world, pos).map(c -> MultipartRedstoneHelper.canConnectRedstone(c, side)).orElseGet(() -> {
            IBlockState state = world.func_180495_p(pos);
            return state.func_177230_c().canConnectRedstone(state, world, pos, side.func_176734_d());
        });
    }

    public static int getWeakPower(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return MultipartHelper.getContainer(world, pos).map(c -> MultipartRedstoneHelper.getWeakPower(c, side)).orElseGet(() -> world.func_180495_p(pos).func_185911_a(world, pos, side.func_176734_d()));
    }

    public static int getStrongPower(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return MultipartHelper.getContainer(world, pos).map(c -> MultipartRedstoneHelper.getStrongPower(c, side)).orElseGet(() -> world.func_180495_p(pos).func_185893_b(world, pos, side.func_176734_d()));
    }

    public static boolean canConnectRedstone(IBlockAccess world, BlockPos pos, EnumEdgeSlot edge, EnumFacing side) {
        return MultipartHelper.getContainer(world, pos).map(c -> MultipartRedstoneHelper.canConnectRedstone(c, edge, side)).orElseGet(() -> {
            IBlockState state = world.func_180495_p(pos);
            return state.func_177230_c().canConnectRedstone(state, world, pos, side.func_176734_d());
        });
    }

    public static int getWeakPower(IBlockAccess world, BlockPos pos, EnumEdgeSlot edge, EnumFacing side) {
        return MultipartHelper.getContainer(world, pos).map(c -> MultipartRedstoneHelper.getWeakPower(c, edge, side)).orElseGet(() -> world.func_180495_p(pos).func_185911_a(world, pos, side.func_176734_d()));
    }

    public static int getStrongPower(IBlockAccess world, BlockPos pos, EnumEdgeSlot edge, EnumFacing side) {
        return MultipartHelper.getContainer(world, pos).map(c -> MultipartRedstoneHelper.getStrongPower(c, edge, side)).orElseGet(() -> world.func_180495_p(pos).func_185893_b(world, pos, side.func_176734_d()));
    }
}

