/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entities;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.IComplexEffect;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.entities.EntityTechnicalAmbient;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.util.ASDataSerializers;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.LootTableUtil;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.effect.ShootingStarExplosion;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityShootingStar
extends EntityThrowable
implements EntityTechnicalAmbient {
    private static final DataParameter<Vector3> SHOOT_CONSTANT = EntityDataManager.func_187226_a(EntityShootingStar.class, ASDataSerializers.VECTOR);
    private static final DataParameter<Long> EFFECT_SEED = EntityDataManager.func_187226_a(EntityShootingStar.class, ASDataSerializers.LONG);
    private static final DataParameter<Long> LAST_UPDATE = EntityDataManager.func_187226_a(EntityShootingStar.class, ASDataSerializers.LONG);
    private boolean removalPending = true;

    public EntityShootingStar(World worldIn) {
        super(worldIn);
    }

    public EntityShootingStar(World worldIn, double x, double y, double z, Vector3 shot) {
        super(worldIn, x, y, z);
        this.func_70105_a(0.1f, 0.1f);
        this.removalPending = false;
        this.field_70180_af.func_187227_b(SHOOT_CONSTANT, (Object)shot);
        this.field_70180_af.func_187227_b(EFFECT_SEED, (Object)this.field_70146_Z.nextLong());
        this.field_70180_af.func_187227_b(LAST_UPDATE, (Object)worldIn.func_82737_E());
        this.correctMovement();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHOOT_CONSTANT, (Object)new Vector3());
        this.field_70180_af.func_187214_a(EFFECT_SEED, (Object)0L);
        this.field_70180_af.func_187214_a(LAST_UPDATE, (Object)0L);
    }

    private void correctMovement() {
        Vector3 shot = (Vector3)this.field_70180_af.func_187225_a(SHOOT_CONSTANT);
        this.field_70159_w = shot.getX();
        this.field_70179_y = shot.getZ();
        this.field_70181_x = this.field_70163_u >= 500.0 ? -0.09 : (double)(-0.7f * (1.0f - (float)this.field_70163_u / 1000.0f));
    }

    public long getEffectSeed() {
        return (Long)this.field_70180_af.func_187225_a(EFFECT_SEED);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        long lastTrackedTick = (Long)this.field_70180_af.func_187225_a(LAST_UPDATE);
        if (!this.field_70170_p.field_72995_K) {
            RayTraceResult rtr;
            if (this.removalPending || !ConstellationSkyHandler.getInstance().isNight(this.field_70170_p) || this.field_70170_p.func_82737_E() - lastTrackedTick >= 20L) {
                this.func_70106_y();
                return;
            }
            this.field_70180_af.func_187227_b(LAST_UPDATE, (Object)this.field_70170_p.func_82737_E());
            if ((this.func_70090_H() || this.func_180799_ab()) && !ForgeEventFactory.onProjectileImpact((EntityThrowable)this, (RayTraceResult)(rtr = new RayTraceResult(new Vec3d(0.0, 0.0, 0.0), EnumFacing.UP, this.func_180425_c())))) {
                this.func_70184_a(rtr);
            }
        }
        this.correctMovement();
        if (this.field_70170_p.field_72995_K) {
            if (!ConstellationSkyHandler.getInstance().isNight(this.field_70170_p) || this.field_70170_p.func_82737_E() - lastTrackedTick >= 20L) {
                this.func_70106_y();
                return;
            }
            this.spawnEffects();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnEffects() {
        Vector3 shot = (Vector3)this.field_70180_af.func_187225_a(SHOOT_CONSTANT);
        float positionDist = 96.0f;
        EntityComplexFX.RenderOffsetController renderCtrl = (fx, currentRenderPos, currentMotion, pTicks) -> {
            EntityPlayerSP pl = Minecraft.func_71410_x().field_71439_g;
            if (pl == null) {
                return currentRenderPos;
            }
            EntityFXFacingParticle pt = (EntityFXFacingParticle)fx;
            Vector3 v = pt.getPosition().clone().subtract(Vector3.atEntityCenter((Entity)pl));
            if (v.length() <= (double)positionDist) {
                return currentRenderPos;
            }
            return Vector3.atEntityCenter((Entity)pl).add(v.normalize().multiply(positionDist));
        };
        EntityComplexFX.ScaleFunction<IComplexEffect> scaleFct = (fx, pos, pTicks, scaleIn) -> {
            EntityPlayerSP pl = Minecraft.func_71410_x().field_71439_g;
            if (pl == null) {
                return scaleIn;
            }
            scaleIn = new EntityComplexFX.ScaleFunction.Shrink<EntityComplexFX>().getScale((EntityComplexFX)fx, pos, pTicks, scaleIn);
            EntityFXFacingParticle pt = (EntityFXFacingParticle)fx;
            Vector3 v = pt.getPosition().clone().subtract(Vector3.atEntityCenter((Entity)pl));
            float mul = v.length() <= (double)positionDist ? 1.0f : (float)((double)positionDist / v.length());
            return scaleIn * 0.25f + (mul * scaleIn - scaleIn * 0.25f);
        };
        for (int i = 0; i < 4; ++i) {
            if (this.field_70146_Z.nextFloat() > 0.75f) continue;
            Vector3 dir = shot.clone().multiply(this.field_70146_Z.nextFloat() * -0.6f);
            dir.setX(dir.getX() + (double)this.field_70146_Z.nextFloat() * 0.008 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
            dir.setZ(dir.getZ() + (double)this.field_70146_Z.nextFloat() * 0.008 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            p.setColor(Color.WHITE).setDistanceRemovable(false).scale(1.2f + this.field_70146_Z.nextFloat() * 0.5f).motion(dir.getX(), dir.getY(), dir.getZ()).setAlphaMultiplier(0.85f).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).setMaxAge(90 + this.field_70146_Z.nextInt(40));
            p.setRenderOffsetController(renderCtrl);
            p.setScaleFunction(scaleFct);
        }
        float scale = 4.0f + this.field_70146_Z.nextFloat() * 3.0f;
        int age = 5 + this.field_70146_Z.nextInt(2);
        Random seeded = new Random(this.getEffectSeed());
        EntityFXFacingParticle star = EffectHelper.genericFlareParticle(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        star.setColor(Color.getHSBColor(seeded.nextFloat() * 360.0f, 1.0f, 1.0f)).setDistanceRemovable(false).scale(scale).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).setMaxAge(age);
        star.setRenderOffsetController(renderCtrl);
        star.setScaleFunction(scaleFct);
        EntityFXFacingParticle st2 = EffectHelper.genericFlareParticle(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        st2.setColor(Color.WHITE).setDistanceRemovable(false).scale(scale * 0.6f).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).setMaxAge(Math.round((float)age * 1.5f));
        st2.setRenderOffsetController(renderCtrl);
        st2.setScaleFunction(scaleFct);
    }

    protected void func_70184_a(RayTraceResult result) {
        if (this.removalPending || result.field_72313_a == RayTraceResult.Type.MISS) {
            return;
        }
        this.func_70106_y();
        BlockPos hit = result.func_178782_a();
        if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
            hit = result.field_72308_g.func_180425_c();
        }
        if (!this.field_70170_p.field_72995_K && MiscUtils.isChunkLoaded(this.field_70170_p, hit)) {
            Fluid f;
            IBlockState state = this.field_70170_p.func_180495_p(hit);
            boolean eligableForExplosion = true;
            if (MiscUtils.isFluidBlock(state) && (f = MiscUtils.tryGetFuild(state)) != null && f.getTemperature(this.field_70170_p, hit) <= 300) {
                eligableForExplosion = false;
            }
            Vector3 v = Vector3.atEntityCenter((Entity)this);
            ShootingStarExplosion.play(this.field_70170_p, v, !eligableForExplosion, this.getEffectSeed());
            EntityItem generated = new EntityItem(this.field_70170_p, v.getX(), v.getY(), v.getZ(), new ItemStack((Item)ItemsAS.fragmentCapsule));
            Vector3 m = new Vector3();
            MiscUtils.applyRandomOffset(m, this.field_70146_Z, 0.25f);
            generated.field_70159_w = m.getX();
            generated.field_70181_x = Math.abs(m.getY());
            generated.field_70179_y = m.getZ();
            generated.func_174867_a(20);
            this.field_70170_p.func_72838_d((Entity)generated);
            LootTable table = this.field_70170_p.func_184146_ak().func_186521_a(LootTableUtil.LOOT_TABLE_SHOOTING_STAR);
            if (table != null && this.field_70170_p instanceof WorldServer) {
                LootContext context = new LootContext.Builder((WorldServer)this.field_70170_p).func_186471_a();
                List stacks = table.func_186462_a(this.field_70146_Z, context);
                for (ItemStack stack : stacks) {
                    ItemUtils.dropItemNaturally(this.field_70170_p, v.getX(), v.getY(), v.getZ(), stack);
                }
            }
        }
    }

    protected float func_70185_h() {
        return 0.0f;
    }
}

