/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting;

import hellfirepvp.astralsorcery.common.crafting.helper.FluidIngredient;
import hellfirepvp.astralsorcery.common.item.base.render.ItemGatedVisibility;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.ItemComparator;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public final class ItemHandle {
    private static final Constructor<CompoundIngredient> COMPOUND_CTOR;
    public static ItemHandle EMPTY;
    public static boolean ignoreGatingRequirement;
    public final Type handleType;
    private List<ItemStack> applicableItems = new LinkedList<ItemStack>();
    private String oreDictName = null;
    private FluidStack fluidTypeAndAmount = null;

    private ItemHandle(Type type) {
        this.handleType = type;
    }

    private ItemHandle() {
        this(Type.STACK);
        this.applicableItems.add(ItemStack.field_190927_a);
    }

    public ItemHandle(String oreDictName) {
        this.oreDictName = oreDictName;
        this.handleType = Type.OREDICT;
    }

    public ItemHandle(Fluid fluid) {
        this.fluidTypeAndAmount = new FluidStack(fluid, 1000);
        this.handleType = Type.FLUID;
    }

    public ItemHandle(Fluid fluid, int mbAmount) {
        this.fluidTypeAndAmount = new FluidStack(fluid, mbAmount);
        this.handleType = Type.FLUID;
    }

    public ItemHandle(FluidStack compareStack) {
        this.fluidTypeAndAmount = compareStack.copy();
        this.handleType = Type.FLUID;
    }

    public ItemHandle(@Nonnull ItemStack matchStack) {
        this.applicableItems.add(ItemUtils.copyStackWithSize(matchStack, matchStack.func_190916_E()));
        this.handleType = Type.STACK;
    }

    public ItemHandle(ItemStack ... matchStacks) {
        for (ItemStack stack : matchStacks) {
            this.applicableItems.add(ItemUtils.copyStackWithSize(stack, stack.func_190916_E()));
        }
        this.handleType = Type.STACK;
    }

    public ItemHandle(NonNullList<ItemStack> matchStacks) {
        for (ItemStack stack : matchStacks) {
            this.applicableItems.add(ItemUtils.copyStackWithSize(stack, stack.func_190916_E()));
        }
        this.handleType = Type.STACK;
    }

    public static ItemHandle of(Ingredient ingredient) {
        return new ItemHandle(ingredient.func_193365_a());
    }

    public static ItemHandle getCrystalVariant(boolean hasToBeTuned, boolean hasToBeCelestial) {
        if (hasToBeTuned) {
            if (hasToBeCelestial) {
                return new ItemHandle(new ItemStack((Item)ItemsAS.tunedCelestialCrystal));
            }
            ItemHandle handle = new ItemHandle(new ItemStack((Item)ItemsAS.tunedRockCrystal));
            handle.applicableItems.add(new ItemStack((Item)ItemsAS.tunedCelestialCrystal));
            return handle;
        }
        if (hasToBeCelestial) {
            ItemHandle handle = new ItemHandle(new ItemStack((Item)ItemsAS.celestialCrystal));
            handle.applicableItems.add(new ItemStack((Item)ItemsAS.tunedCelestialCrystal));
            return handle;
        }
        ItemHandle handle = new ItemHandle(new ItemStack((Item)ItemsAS.rockCrystal));
        handle.applicableItems.add(new ItemStack((Item)ItemsAS.celestialCrystal));
        handle.applicableItems.add(new ItemStack((Item)ItemsAS.tunedRockCrystal));
        handle.applicableItems.add(new ItemStack((Item)ItemsAS.tunedCelestialCrystal));
        return handle;
    }

    public NonNullList<ItemStack> getApplicableItems() {
        if (this.oreDictName != null) {
            NonNullList stacks = OreDictionary.getOres((String)this.oreDictName);
            NonNullList out = NonNullList.func_191196_a();
            for (ItemStack oreDictIn : stacks) {
                if (oreDictIn.func_77952_i() == Short.MAX_VALUE && !oreDictIn.func_77984_f()) {
                    oreDictIn.func_77973_b().func_150895_a(oreDictIn.func_77973_b().func_77640_w(), out);
                    continue;
                }
                out.add((Object)oreDictIn);
            }
            return out;
        }
        if (this.fluidTypeAndAmount != null) {
            return NonNullList.func_191197_a((int)1, (Object)UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)this.fluidTypeAndAmount.getFluid()));
        }
        NonNullList l = NonNullList.func_191196_a();
        l.addAll(this.applicableItems);
        return l;
    }

    @Deprecated
    public Object getObjectForRecipe() {
        if (this.oreDictName != null) {
            return this.oreDictName;
        }
        if (this.fluidTypeAndAmount != null) {
            return UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)this.fluidTypeAndAmount.getFluid());
        }
        return this.applicableItems;
    }

    @SideOnly(value=Side.CLIENT)
    public NonNullList<ItemStack> getApplicableItemsForRender() {
        NonNullList<ItemStack> applicable = this.getApplicableItems();
        Iterator iterator = applicable.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            if (stack.func_190926_b()) continue;
            Item i = stack.func_77973_b();
            if (ignoreGatingRequirement || !(i instanceof ItemGatedVisibility) || ((ItemGatedVisibility)i).isSupposedToSeeInRender(stack)) continue;
            iterator.remove();
        }
        return applicable;
    }

    public Ingredient getRecipeIngredient() {
        switch (this.handleType) {
            case OREDICT: {
                return new OreIngredient(this.oreDictName);
            }
            case FLUID: {
                return new FluidIngredient(new FluidStack(this.fluidTypeAndAmount.getFluid(), 1000));
            }
        }
        ArrayList<HandleIngredient> ingredients = new ArrayList<HandleIngredient>();
        for (ItemStack stack : this.applicableItems) {
            HandleIngredient i;
            if (stack.func_190926_b() || (i = new HandleIngredient(stack)) == Ingredient.field_193370_a) continue;
            ingredients.add(i);
        }
        try {
            return (Ingredient)COMPOUND_CTOR.newInstance(ingredients);
        }
        catch (Exception exception) {
            return Ingredient.field_193370_a;
        }
    }

    @Nullable
    public String getOreDictName() {
        return this.oreDictName;
    }

    @Nullable
    public FluidStack getFluidTypeAndAmount() {
        return this.fluidTypeAndAmount;
    }

    public boolean matchCrafting(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        switch (this.handleType) {
            case OREDICT: {
                for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                    String name = OreDictionary.getOreName((int)id);
                    if (name == null || !name.equals(this.oreDictName)) continue;
                    return true;
                }
                return false;
            }
            case STACK: {
                for (ItemStack applicable : this.applicableItems) {
                    if (!ItemComparator.compare(applicable, stack, ItemComparator.Clause.ITEM, ItemComparator.Clause.META_WILDCARD, ItemComparator.Clause.NBT_LEAST)) continue;
                    return true;
                }
                return false;
            }
            case FLUID: {
                FluidStack contained = FluidUtil.getFluidContained((ItemStack)stack);
                if (contained == null || contained.getFluid() == null || !contained.getFluid().equals(this.fluidTypeAndAmount.getFluid())) {
                    return false;
                }
                return ItemUtils.drainFluidFromItem(stack, this.fluidTypeAndAmount, false).isSuccess();
            }
        }
        return false;
    }

    public void serialize(ByteBuf byteBuf) {
        byteBuf.writeInt(this.handleType.ordinal());
        switch (this.handleType) {
            case OREDICT: {
                ByteBufUtils.writeString(byteBuf, this.oreDictName);
                break;
            }
            case STACK: {
                byteBuf.writeInt(this.applicableItems.size());
                for (ItemStack applicableItem : this.applicableItems) {
                    ByteBufUtils.writeItemStack(byteBuf, applicableItem);
                }
                break;
            }
            case FLUID: {
                ByteBufUtils.writeFluidStack(byteBuf, this.fluidTypeAndAmount);
                break;
            }
        }
    }

    public static ItemHandle deserialize(ByteBuf byteBuf) {
        Type type = Type.values()[byteBuf.readInt()];
        ItemHandle handle = new ItemHandle(type);
        switch (type) {
            case OREDICT: {
                handle.oreDictName = ByteBufUtils.readString(byteBuf);
                break;
            }
            case STACK: {
                int amt = byteBuf.readInt();
                for (int i = 0; i < amt; ++i) {
                    handle.applicableItems.add(ByteBufUtils.readItemStack(byteBuf));
                }
                break;
            }
            case FLUID: {
                handle.fluidTypeAndAmount = ByteBufUtils.readFluidStack(byteBuf);
                break;
            }
        }
        return handle;
    }

    static {
        Constructor ctor;
        EMPTY = new ItemHandle();
        ignoreGatingRequirement = true;
        try {
            ctor = CompoundIngredient.class.getDeclaredConstructor(Collection.class);
        }
        catch (Exception exc) {
            throw new IllegalStateException("Could not find CompoundIngredient Constructor! Recipes can't be created; Exiting execution! Try with AS and forge alone first! Please report this along with exact forge version and other mods.");
        }
        ctor.setAccessible(true);
        COMPOUND_CTOR = ctor;
    }

    public static enum Type {
        OREDICT,
        STACK,
        FLUID;

    }

    public static class HandleIngredient
    extends Ingredient {
        private HandleIngredient(ItemStack stack) {
            super(new ItemStack[]{stack});
        }

        public boolean apply(@Nullable ItemStack other) {
            if (other == null) {
                return false;
            }
            for (ItemStack thisStack : this.field_193371_b) {
                if (!ItemComparator.compare(thisStack, other, ItemComparator.Clause.ITEM, ItemComparator.Clause.META_WILDCARD, ItemComparator.Clause.NBT_LEAST)) continue;
                return true;
            }
            return false;
        }
    }
}

