/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.recipe;

import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import openblocks.OpenBlocks;
import openblocks.common.item.ItemEpicEraser;
import openmods.utils.CustomRecipeBase;
import openmods.utils.InventoryUtils;

public class EpicEraserRecipe
extends CustomRecipeBase {
    public EpicEraserRecipe() {
        super(OpenBlocks.location("eraser").toString());
    }

    private static boolean hasLore(ItemStack itemStack) {
        NBTTagCompound itemTag = itemStack.func_77978_p();
        if (itemTag != null && itemTag.func_150297_b("display", 10)) {
            NBTTagCompound displayTag = itemTag.func_74775_l("display");
            return displayTag.func_150297_b("SillyLore", 9) || displayTag.func_150297_b("Lore", 9);
        }
        return false;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        boolean eraserFound = false;
        boolean loreItemFound = false;
        for (ItemStack itemStack : InventoryUtils.asIterable((IInventory)inv)) {
            if (itemStack.func_190926_b()) continue;
            if (itemStack.func_77973_b() instanceof ItemEpicEraser) {
                if (eraserFound) {
                    return false;
                }
                eraserFound = true;
                continue;
            }
            if (EpicEraserRecipe.hasLore(itemStack)) {
                if (loreItemFound) {
                    return false;
                }
                loreItemFound = true;
                continue;
            }
            return false;
        }
        return eraserFound && loreItemFound;
    }

    @Nonnull
    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack targetItem = ItemStack.field_190927_a;
        boolean eraserFound = false;
        for (ItemStack itemStack : InventoryUtils.asIterable((IInventory)inv)) {
            if (itemStack.func_190926_b()) continue;
            if (itemStack.func_77973_b() instanceof ItemEpicEraser) {
                if (eraserFound) {
                    return ItemStack.field_190927_a;
                }
                eraserFound = true;
                continue;
            }
            if (EpicEraserRecipe.hasLore(itemStack)) {
                if (!targetItem.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                targetItem = itemStack;
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (!eraserFound || targetItem.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = targetItem.func_77946_l();
        NBTTagCompound itemTag = result.func_77978_p();
        NBTTagCompound displayTag = itemTag.func_74775_l("display");
        displayTag.func_82580_o("Lore");
        displayTag.func_82580_o("SillyLore");
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height > 1;
    }
}

