/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.TileBase;
import java.io.IOException;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileMill
extends TileBase {
    protected float speed = 0.01f;
    protected int stage = 0;
    public int charge = 0;
    public float progress;

    protected TileMill() {
    }

    @Override
    public void updateClientSide() {
        this.update(false);
    }

    @Override
    public void updateServerSide() {
        this.update(true);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        data.writeInt(this.charge);
        data.writeFloat(this.speed);
        data.writeInt(this.stage);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.charge = data.readInt();
        this.speed = data.readFloat();
        this.stage = data.readInt();
    }

    private void update(boolean isSimulating) {
        if (this.charge <= 0) {
            if (this.stage > 0) {
                this.progress += this.speed;
            }
            if ((double)this.progress > 0.5) {
                this.stage = 2;
            }
            if (this.progress > 1.0f) {
                this.progress = 0.0f;
                this.stage = 0;
            }
            return;
        }
        this.progress += this.speed;
        if (this.stage <= 0) {
            this.stage = 1;
        }
        if ((double)this.progress > 0.5 && this.stage == 1) {
            this.stage = 2;
            if (this.charge < 7 && isSimulating) {
                ++this.charge;
                this.setNeedsNetworkUpdate();
            }
        }
        if (this.progress > 1.0f) {
            this.progress = 0.0f;
            this.stage = 0;
            if (this.charge >= 7) {
                this.activate();
            }
        }
    }

    protected abstract void activate();
}

