/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.common.unit;

import engineers.workshop.client.GuiBase;
import engineers.workshop.client.container.slot.crafting.SlotUnitCraftingGrid;
import engineers.workshop.client.container.slot.crafting.SlotUnitCraftingOutput;
import engineers.workshop.client.container.slot.crafting.SlotUnitCraftingResult;
import engineers.workshop.client.container.slot.crafting.SlotUnitCraftingStorage;
import engineers.workshop.client.page.Page;
import engineers.workshop.common.items.Upgrade;
import engineers.workshop.common.table.TileTable;
import engineers.workshop.common.unit.Unit;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UnitCraft
extends Unit {
    public static final int RESULT_AUTO_OFFSET = -5;
    private static final int START_X = 5;
    private static final int START_Y = 5;
    private static final int SLOT_SIZE = 18;
    private static final int GRID_WIDTH = 3;
    private static final int GRID_HEIGHT = 3;
    public static final int GRID_SIZE = 9;
    private static final int RESULT_OFFSET_X = 94;
    private static final int RESULT_OFFSET_Y = 18;
    private static final int STORAGE_COUNT = 6;
    private static final int STORAGE_Y = 65;
    private static final int ARROW_X = 61;
    private static final int ARROW_Y = 19;
    private static final int CLEAR_SRC_X = 48;
    private static final int CLEAR_SRC_Y = 112;
    private static final int CLEAR_SIZE = 9;
    private static final int CLEAR_OFFSET_X = 3;
    private static final int CLEAR_OFFSET_Y = 0;
    private static final int CAN_CRAFT_DELAY = 10;
    private int gridId;
    private int resultId;
    private int outputId;
    private CraftingBase inventoryCrafting = new CraftingWrapper();
    private boolean canAutoCraft;
    private boolean lockedRecipeGeneration;
    private int canCraftTick = 0;
    private CraftingBase oldGrid;

    public UnitCraft(TileTable table, Page page, int id, int x, int y) {
        super(table, page, id, x, y);
    }

    @Override
    public int createSlots(int id) {
        this.gridId = id;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.addSlot(new SlotUnitCraftingGrid(this.table, this.page, id++, this.x + 5 + x * 18, this.y + 5 + y * 18, this));
            }
        }
        for (int i = 0; i < 6; ++i) {
            this.addSlot(new SlotUnitCraftingStorage(this.table, this.page, id++, this.x + 5 + i * 18, this.y + 65, this));
        }
        this.resultId = id;
        this.addSlot(new SlotUnitCraftingResult(this.table, this.page, id++, this.x + 5 + 94, this.y + 5 + 18, this));
        this.outputId = id;
        this.addSlot(new SlotUnitCraftingOutput(this.table, this.page, id++, this.x + 5 + 94, this.y + 5 + 36, this));
        return id;
    }

    @Override
    public boolean isEnabled() {
        ItemStack item = this.table.getUpgradePage().getUpgradeMainItem(this.id);
        return !item.func_190926_b() && Upgrade.ParentType.CRAFTING.isValidParent(item);
    }

    @Override
    protected boolean canCharge() {
        return super.canCharge() && this.table.getUpgradePage().hasUpgrade(this.id, Upgrade.AUTO_CRAFTER);
    }

    public void onCrafting(EntityPlayer player, ItemStack item) {
        this.onCrafted(player, item);
        this.lockedRecipeGeneration = true;
        try {
            this.onCrafting(this.inventoryCrafting, player == null, false);
        }
        finally {
            this.lockedRecipeGeneration = false;
        }
        this.onGridChanged();
    }

    private void onCrafted(EntityPlayer player, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return;
        }
        Item item = itemStack.func_77973_b();
        try {
            item.func_77622_d(itemStack, this.table.func_145831_w(), player);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiBase gui, int mX, int mY) {
        int index;
        super.draw(gui, mX, mY);
        boolean isEmpty = true;
        for (int i = this.gridId; i < this.gridId + 9; ++i) {
            if (this.table.func_70301_a(i).func_190926_b()) continue;
            isEmpty = false;
            break;
        }
        int x = this.x + 5 + 54 + 3;
        int y = this.y + 5 + 0;
        if (isEmpty) {
            index = 0;
        } else if (gui.inBounds(x, y, 9, 9, mX, mY)) {
            index = 2;
            gui.drawMouseOver("Clear grid");
        } else {
            index = 1;
        }
        gui.drawRect(x, y, 48 + index * 9, 112, 9, 9);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiBase gui, int mX, int mY) {
        super.onClick(gui, mX, mY);
        if (gui.inBounds(this.x + 5 + 54 + 3, this.y + 5 + 0, 9, 9, mX, mY)) {
            this.table.clearGridSend(this.id);
        }
    }

    private void onCrafting(CraftingBase crafting, boolean auto, boolean fake) {
        for (int i = 0; i < 9; ++i) {
            ItemStack containerItem;
            int j;
            ItemStack itemStack = crafting.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            int id = i;
            int n = j = auto ? 0 : 9;
            while (j < crafting.getFullSize()) {
                ItemStack other;
                if (i != j && !(other = crafting.func_70301_a(j)).func_190926_b() && (j >= 9 || other.func_190916_E() > itemStack.func_190916_E()) && itemStack.func_77969_a(other) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)other)) {
                    id = j;
                    itemStack = other;
                    break;
                }
                ++j;
            }
            crafting.func_70298_a(id, 1);
            if (!itemStack.func_77973_b().hasContainerItem(itemStack) || (containerItem = itemStack.func_77973_b().getContainerItem(itemStack)).func_77984_f() && containerItem.func_77952_i() > containerItem.func_77958_k()) continue;
            crafting.func_70299_a(id, containerItem);
        }
    }

    public int getGridId() {
        return this.gridId;
    }

    public void onGridChanged() {
        if (!this.lockedRecipeGeneration) {
            IRecipe recipe = this.inventoryCrafting.getRecipe();
            ItemStack result = this.inventoryCrafting.getResult(recipe);
            if (!result.func_190926_b()) {
                result = result.func_77946_l();
            }
            this.table.func_70299_a(this.resultId, result);
            if (this.table.getUpgradePage().hasUpgrade(this.id, Upgrade.AUTO_CRAFTER)) {
                if (recipe == null) {
                    this.canAutoCraft = false;
                } else {
                    CraftingDummy dummy = new CraftingDummy(this.inventoryCrafting);
                    this.onCrafting(dummy, true, true);
                    this.canAutoCraft = dummy.isMatch(recipe);
                }
            }
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (++this.canCraftTick == 10) {
            this.canCraftTick = 0;
            if (this.oldGrid == null || !this.oldGrid.equals((Object)this.inventoryCrafting)) {
                this.oldGrid = new CraftingDummy(this.inventoryCrafting);
                this.onGridChanged();
            }
        }
    }

    public void onUpgradeChange() {
        if (this.table.getUpgradePage().getUpgradeCount(this.id, Upgrade.AXE) > 0 && this.table.getUpgradePage().getUpgradeCount(this.id, Upgrade.AUTO_CRAFTER) > 0) {
            for (int i = 0; i < 9; ++i) {
                this.table.getSlots().get(i + this.gridId).setEnabled(false);
            }
            this.table.getSlots().get(this.gridId + 4).setEnabled(true);
        } else {
            for (int i = 0; i < 9; ++i) {
                this.table.getSlots().get(i + this.gridId).setEnabled(true);
            }
        }
        this.onGridChanged();
    }

    @Override
    protected int getArrowX() {
        return 66;
    }

    @Override
    protected int getArrowY() {
        int offset = 0;
        if (this.table.getUpgradePage().hasUpgrade(this.id, Upgrade.AUTO_CRAFTER)) {
            offset = -5;
        }
        return 24 + offset;
    }

    @Override
    protected ItemStack getProductionResult() {
        ItemStack result;
        if (this.table.getUpgradePage().hasUpgrade(this.id, Upgrade.AUTO_CRAFTER) && !(result = this.table.func_70301_a(this.resultId)).func_190926_b() && this.canAutoCraft) {
            return result;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    protected int getOutputId() {
        return this.outputId;
    }

    @Override
    protected void onProduction(ItemStack result) {
        this.onCrafting(null, result);
    }

    private class CraftingBase
    extends InventoryCrafting {
        private static final int INVENTORY_WIDTH = 3;
        private static final int INVENTORY_HEIGHT = 3;

        public CraftingBase() {
            super(null, 3, 3);
        }

        public final int func_70302_i_() {
            return 9;
        }

        protected int getFullSize() {
            return 9 + (UnitCraft.this.table.getUpgradePage().hasUpgrade(UnitCraft.this.id, Upgrade.STORAGE) ? 6 : 0);
        }

        public ItemStack func_70298_a(int id, int count) {
            ItemStack item = this.func_70301_a(id);
            if (!item.func_190926_b()) {
                if (item.func_190916_E() <= count) {
                    this.func_70299_a(id, ItemStack.field_190927_a);
                    return item;
                }
                ItemStack result = item.func_77979_a(count);
                if (item.func_190916_E() == 0) {
                    this.func_70299_a(id, ItemStack.field_190927_a);
                }
                return result;
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack func_70463_b(int x, int y) {
            if (x >= 0 && x < 3) {
                int id = x + y * 3;
                return this.func_70301_a(id);
            }
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack getResult(IRecipe recipe) {
            return recipe == null ? ItemStack.field_190927_a : recipe.func_77572_b((InventoryCrafting)this);
        }

        public boolean isMatch(IRecipe recipe) {
            return recipe.func_77569_a((InventoryCrafting)this, UnitCraft.this.table.func_145831_w());
        }

        public IRecipe getRecipe() {
            for (IRecipe recipe : CraftingManager.field_193380_a) {
                if (!this.isMatch(recipe)) continue;
                return recipe;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CraftingBase)) {
                return false;
            }
            CraftingBase crafting = (CraftingBase)((Object)obj);
            if (this.getFullSize() != crafting.getFullSize()) {
                return false;
            }
            for (int i = 0; i < this.getFullSize(); ++i) {
                if (ItemStack.func_77989_b((ItemStack)this.func_70301_a(i), (ItemStack)crafting.func_70301_a(i))) continue;
                return false;
            }
            return true;
        }
    }

    private class CraftingDummy
    extends CraftingBase {
        private NonNullList<ItemStack> items;

        private CraftingDummy(CraftingBase base) {
            this.items = NonNullList.func_191197_a((int)base.getFullSize(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < this.items.size(); ++i) {
                ItemStack itemStack = base.func_70301_a(i);
                if (itemStack.func_190926_b()) continue;
                this.items.set(i, (Object)itemStack.func_77946_l());
            }
        }

        @Override
        public int getFullSize() {
            return this.items.size();
        }

        public ItemStack func_70301_a(int id) {
            return (ItemStack)this.items.get(id);
        }

        public void func_70299_a(int id, ItemStack item) {
            this.items.set(id, (Object)item);
        }
    }

    private class CraftingWrapper
    extends CraftingBase {
        private CraftingWrapper() {
        }

        public ItemStack func_70301_a(int id) {
            return UnitCraft.this.table.func_70301_a(UnitCraft.this.gridId + id);
        }

        public void func_70299_a(int id, ItemStack item) {
            UnitCraft.this.table.func_70299_a(UnitCraft.this.gridId + id, item);
        }
    }
}

