/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.conduit.data;

import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IConduitTexture;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.invpanel.capability.CapabilityDatabaseHandler;
import crazypants.enderio.base.invpanel.capability.InventoryDatabaseSource;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.conduits.conduit.AbstractConduit;
import crazypants.enderio.conduits.render.ConduitTexture;
import crazypants.enderio.invpanel.conduit.data.DataConduitNetwork;
import crazypants.enderio.invpanel.conduit.data.DataSettings;
import crazypants.enderio.invpanel.conduit.data.IDataConduit;
import crazypants.enderio.invpanel.init.InvpanelObject;
import crazypants.enderio.invpanel.invpanel.TileInventoryPanel;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class DataConduit
extends AbstractConduit
implements IDataConduit {
    @Nonnull
    static final Map<String, IConduitTexture> ICONS = new HashMap<String, IConduitTexture>();
    protected DataConduitNetwork network;
    private Map<EnumFacing, InventoryDatabaseSource> sources = new EnumMap<EnumFacing, InventoryDatabaseSource>(EnumFacing.class);

    @Override
    public boolean canConnectToExternal(@Nonnull EnumFacing direction, boolean ignoreConnectionMode) {
        BlockPos pos;
        World world = this.getBundle().getBundleworld();
        TileEntity te = world.func_175625_s((pos = this.getBundle().getLocation()).func_177972_a(direction));
        return te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d());
    }

    @Override
    @Nonnull
    public ITabPanel createGuiPanel(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        return new DataSettings(gui, con);
    }

    @Override
    public boolean updateGuiPanel(@Nonnull ITabPanel panel) {
        if (panel instanceof DataSettings) {
            return ((DataSettings)panel).updateConduit(this);
        }
        return false;
    }

    @Override
    public int getGuiPanelTabOrder() {
        return 8;
    }

    @Override
    @Nonnull
    public Class<? extends IConduit> getBaseConduitType() {
        return IDataConduit.class;
    }

    @Override
    @Nonnull
    public ItemStack createItem() {
        return new ItemStack(InvpanelObject.item_data_conduit.getItemNN());
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return facing != null && capability == CapabilityDatabaseHandler.DATABASE_HANDLER_CAPABILITY && this.externalConnections.contains(facing) && this.getConnectionMode(facing) != ConnectionMode.DISABLED;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityDatabaseHandler.DATABASE_HANDLER_CAPABILITY) {
            return (T)CapabilityDatabaseHandler.DATABASE_HANDLER_CAPABILITY.cast((Object)this.getNetwork());
        }
        return null;
    }

    @Nonnull
    public DataConduitNetwork createNetworkForType() {
        return new DataConduitNetwork();
    }

    @Nullable
    public DataConduitNetwork getNetwork() throws NullPointerException {
        return this.network;
    }

    @Override
    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        this.network = (DataConduitNetwork)network;
        return super.setNetwork(network);
    }

    @Override
    public void clearNetwork() {
        this.network = null;
    }

    @Override
    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        if (ToolUtil.isToolEquipped(player, hand)) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K) {
                CollidableComponent component = res.component;
                EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
                if (component.isCore()) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, ConnectionMode.IN_OUT);
                        return true;
                    }
                    return ConduitUtil.connectConduits(this, faceHit);
                }
                EnumFacing connDir = component.getDirection();
                if (this.externalConnections.contains(connDir)) {
                    this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                } else if (this.containsConduitConnection(connDir)) {
                    ConduitUtil.disconnectConduits(this, connDir);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void invalidate() {
        if (this.network != null) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                this.network.removeSource(this.sources.get(dir));
            }
        }
    }

    @Override
    public void onAddedToBundle() {
        super.onAddedToBundle();
        NNList.FACING.apply(this::checkConnections);
    }

    @Override
    public void externalConnectionAdded(@Nonnull EnumFacing dir) {
        super.externalConnectionAdded(dir);
        this.checkConnections(dir);
    }

    @Override
    public void externalConnectionRemoved(@Nonnull EnumFacing dir) {
        super.externalConnectionRemoved(dir);
        this.checkConnections(dir);
    }

    @Override
    public void checkConnections(@Nonnull EnumFacing dir) {
        IItemHandler inv;
        if (this.getExternalConnections().contains(dir) && this.getConnectionMode(dir).isActive() && (inv = this.getExternalInventory(dir)) != null) {
            this.addSource(dir, new InventoryDatabaseSource(this.getBundle().getLocation(), inv));
            return;
        }
        this.removeSource(dir);
    }

    @Override
    @Nullable
    public IItemHandler getExternalInventory(@Nonnull EnumFacing dir) {
        BlockPos pos;
        World world;
        TileEntity te;
        if (this.getConnectionMode(dir).isActive() && (te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)(world = this.getBundle().getBundleworld()), (BlockPos)(pos = this.getBundle().getLocation()).func_177972_a(dir))) != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()) && !(te instanceof TileInventoryPanel)) {
            return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d());
        }
        return null;
    }

    @Override
    public void addSource(@Nonnull EnumFacing dir, @Nonnull InventoryDatabaseSource source) {
        if (this.network != null) {
            this.network.addSource(source);
        }
        this.sources.put(dir, source);
    }

    @Override
    public void removeSource(@Nonnull EnumFacing dir) {
        if (this.network != null) {
            this.network.removeSource(this.sources.get(dir));
        }
        this.sources.remove(dir);
    }

    @Override
    public void connectionsChanged() {
        super.connectionsChanged();
        this.invalidate();
        NNList.FACING.apply(this::checkConnections);
    }

    @Override
    @Nonnull
    public IConduitTexture getTextureForState(@Nonnull CollidableComponent component) {
        return ICONS.get(component.isCore() ? "blocks/data_conduit_core" : "blocks/data_conduit");
    }

    @Override
    @Nullable
    public IConduitTexture getTransmitionTextureForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @Override
    @Nullable
    public Vector4f getTransmitionTextureColorForState(@Nonnull CollidableComponent component) {
        return null;
    }

    static {
        ICONS.put("blocks/data_conduit", new ConduitTexture(TextureRegistry.registerTexture("blocks/data_conduit"), ConduitTexture.arm(0)));
        ICONS.put("blocks/data_conduit_core", new ConduitTexture(TextureRegistry.registerTexture("blocks/data_conduit_core"), ConduitTexture.core()));
    }
}

