/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.materialsystem.MaterialException;
import com.teamacronymcoders.base.materialsystem.MaterialSystem;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPart;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPartSave;
import com.teamacronymcoders.base.materialsystem.materials.Material;
import com.teamacronymcoders.base.materialsystem.parts.Part;
import com.teamacronymcoders.base.registrysystem.ItemRegistry;
import com.teamacronymcoders.base.savesystem.SaveLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import org.apache.commons.lang3.tuple.Pair;

public class MaterialUser {
    private final IBaseMod mod;
    private Map<String, Integer> nameMapping = Maps.newHashMap();
    private int nextId = 0;
    private BiMap<Integer, MaterialPart> materialPartBiMap = HashBiMap.create();

    public MaterialUser(IBaseMod mod) {
        this.mod = mod;
    }

    public void setup() {
        this.nameMapping.putAll(SaveLoader.getSavedObject("material_parts_" + this.mod.getID(), MaterialPartSave.class).getMaterialMappings());
        this.nameMapping.values().forEach(id -> {
            if (id > this.nextId) {
                this.nextId = id + 1;
            }
        });
    }

    public void finishUp() {
        MaterialPartSave save;
        ArrayList parts = Lists.newArrayList((Iterable)this.materialPartBiMap.values());
        for (MaterialPart materialPart : parts) {
            try {
                materialPart.getData().validate();
            }
            catch (MaterialException e) {
                this.logError("MaterialPart with name " + materialPart.getLocalizedName() + " had an error when validating data. Error: " + e.getMessage());
            }
            materialPart.setup();
        }
        if (this.hasErred()) {
            this.logError("Found Errors with Material System Loading. Saving Back up");
            save = MaterialPartSave.of(this.nameMapping);
        } else {
            save = MaterialPartSave.of(this.materialPartBiMap.inverse().entrySet().stream().map(entry -> Pair.of((Object)((MaterialPart)entry.getKey()).getUnlocalizedName(), entry.getValue())).collect(Collectors.toMap(Pair::getLeft, Pair::getRight)));
        }
        SaveLoader.saveObject("material_parts_" + this.mod.getID(), save);
    }

    protected boolean hasErred() {
        return false;
    }

    public IBaseMod getMod() {
        return this.mod;
    }

    public MaterialPart getMaterialPart(int itemDamage) {
        return (MaterialPart)this.materialPartBiMap.getOrDefault((Object)itemDamage, (Object)MaterialSystem.MISSING_MATERIAL_PART);
    }

    public int getMaterialPartId(MaterialPart materialPart) {
        return (Integer)this.materialPartBiMap.inverse().get((Object)materialPart);
    }

    public List<MaterialPart> registerPartsForMaterial(Material material, String ... partNames) {
        ArrayList materialParts = Lists.newArrayList();
        for (String partName : partNames) {
            Part part = MaterialSystem.getPart(partName);
            if (part != null) {
                MaterialPart materialPart = new MaterialPart(this, material, part);
                this.registerMaterialPart(materialPart);
                materialParts.add(materialPart);
                continue;
            }
            this.logError("Could not find part " + partName + " for " + material.getName());
        }
        return materialParts;
    }

    public void registerMaterialPart(MaterialPart materialPart) {
        int id = this.nameMapping.containsKey(materialPart.getUnlocalizedName()) ? this.nameMapping.get(materialPart.getUnlocalizedName()) : this.nextId++;
        if (!MaterialSystem.hasMaterialPart(materialPart)) {
            this.materialPartBiMap.put((Object)id, (Object)materialPart);
            MaterialSystem.registerMaterialPart(materialPart);
        } else {
            this.logError(materialPart.getUnlocalizedName() + " is already registered.");
        }
    }

    public void registerItem(Item item) {
        item.func_77637_a((CreativeTabs)MaterialSystem.materialCreativeTab);
        this.mod.getRegistryHolder().getRegistry(ItemRegistry.class, "ITEM").register(item);
    }

    public String getId() {
        return this.getMod().getID();
    }

    public void logError(String errorMessage) {
        this.getMod().getLogger().warning(errorMessage);
    }
}

