/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks.forge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;
import yalter.mousetweaks.Config;
import yalter.mousetweaks.Logger;
import yalter.mousetweaks.Main;
import yalter.mousetweaks.ScrollHandling;
import yalter.mousetweaks.WheelScrollDirection;
import yalter.mousetweaks.WheelSearchOrder;

public class ConfigGui
extends GuiConfig {
    private static Property rmbTweak = new Property("RMB tweak", "true", Property.Type.BOOLEAN);
    private static Property lmbTweakWithItem = new Property("LMB tweak with item", "true", Property.Type.BOOLEAN);
    private static Property lmbTweakWithoutItem = new Property("LMB tweak without item", "true", Property.Type.BOOLEAN);
    private static Property wheelTweak = new Property("Wheel tweak", "true", Property.Type.BOOLEAN);
    private static Property wheelSearchOrder = new Property("Wheel tweak search order", "Last to first", Property.Type.STRING, new String[]{"First to last", "Last to first"});
    private static Property wheelScrollDirection = new Property("Wheel tweak scroll direction", "Down to push, up to pull", Property.Type.STRING, new String[]{"Down to push, up to pull", "Up to push, down to pull", "Inventory position aware"});
    private static Property onTickMethodOrder = new Property("OnTick method order", "Forge, LiteLoader", Property.Type.STRING);
    private static Property scrollHandling = new Property("Scroll handling", "Smooth scrolling, minor issues", Property.Type.STRING, new String[]{"Smooth scrolling, minor issues", "Non-smooth scrolling, no issues"});
    private static Property debug = new Property("Debug", "false", Property.Type.BOOLEAN);
    private boolean is_open = false;

    public ConfigGui(blk parentScreen) {
        super(parentScreen, ConfigGui.getConfigElements(), "mousetweaks", false, false, ".minecraft/config/MouseTweaks.cfg");
        rmbTweak.setComment("Like vanilla right click dragging, but dragging over a slot multiple times puts the item there multiple times.");
        lmbTweakWithItem.setComment("Left click and drag with an item to \"left click\" items of the same type.");
        lmbTweakWithoutItem.setComment("Hold shift, left click and drag without an item to \"shift left click\" items.");
        wheelTweak.setComment("Scroll over items to move them between inventories.");
        wheelSearchOrder.setComment("How to pick the source slot when pulling items via scrolling.");
        wheelScrollDirection.setComment("Inventory position aware means scroll up to push items from the bottom inventory and pull into the top inventory, and vice versa.");
        onTickMethodOrder.setComment("This shouldn't really affect anything, but non-smooth scrolling works only with the Forge OnTick method.");
        scrollHandling.setComment("When set to smooth scrolling, minor issues may be experienced such as scrolling \"through\" JEI or other mods. Non-smooth scrolling works only with the Forge OnTick method.");
        debug.setComment("Enables debug logging output.");
    }

    private static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.add((IConfigElement)new ConfigElement(rmbTweak));
        list.add((IConfigElement)new ConfigElement(lmbTweakWithItem));
        list.add((IConfigElement)new ConfigElement(lmbTweakWithoutItem));
        list.add((IConfigElement)new ConfigElement(wheelTweak));
        list.add((IConfigElement)new ConfigElement(wheelSearchOrder));
        list.add((IConfigElement)new ConfigElement(wheelScrollDirection));
        list.add((IConfigElement)new ConfigElement(onTickMethodOrder));
        list.add((IConfigElement)new ConfigElement(scrollHandling));
        list.add((IConfigElement)new ConfigElement(debug));
        return list;
    }

    public void b() {
        Logger.DebugLog("initGui()");
        if (!this.is_open) {
            this.is_open = true;
            Main.config.read();
            rmbTweak.set(Main.config.rmbTweak);
            lmbTweakWithItem.set(Main.config.lmbTweakWithItem);
            lmbTweakWithoutItem.set(Main.config.lmbTweakWithoutItem);
            wheelTweak.set(Main.config.wheelTweak);
            wheelSearchOrder.set(Main.config.wheelSearchOrder == WheelSearchOrder.FIRST_TO_LAST ? "First to last" : "Last to first");
            wheelScrollDirection.set(this.scrollDirectionDescription());
            onTickMethodOrder.set(Main.config.onTickMethodOrderString());
            scrollHandling.set(scrollHandling.getValidValues()[Main.config.scrollHandling.ordinal()]);
            debug.set(Config.debug);
        }
        super.b();
    }

    private String scrollDirectionDescription() {
        WheelScrollDirection dir = Main.config.wheelScrollDirection;
        if (dir == WheelScrollDirection.NORMAL) {
            return "Down to push, up to pull";
        }
        if (dir == WheelScrollDirection.INVERTED) {
            return "Up to push, down to pull";
        }
        return "Inventory position aware";
    }

    public void m() {
        Logger.DebugLog("onGuiClosed()");
        Main.config.rmbTweak = rmbTweak.getBoolean();
        Main.config.lmbTweakWithItem = lmbTweakWithItem.getBoolean();
        Main.config.lmbTweakWithoutItem = lmbTweakWithoutItem.getBoolean();
        Main.config.wheelTweak = wheelTweak.getBoolean();
        Main.config.wheelSearchOrder = wheelSearchOrder.getString().equals("First to last") ? WheelSearchOrder.FIRST_TO_LAST : WheelSearchOrder.LAST_TO_FIRST;
        Main.config.wheelScrollDirection = this.scrollDirectionFromDescription(wheelScrollDirection.getString());
        Main.config.onTickMethodOrderFromString(onTickMethodOrder.getString());
        Main.config.scrollHandling = ScrollHandling.fromId(Arrays.asList(scrollHandling.getValidValues()).indexOf(scrollHandling.getString()));
        Config.debug = debug.getBoolean();
        Main.config.save();
        Main.findOnTickMethod(true);
        this.is_open = false;
        super.m();
    }

    private WheelScrollDirection scrollDirectionFromDescription(String description) {
        switch (description) {
            case "Down to push, up to pull": {
                return WheelScrollDirection.NORMAL;
            }
            case "Up to push, down to pull": {
                return WheelScrollDirection.INVERTED;
            }
        }
        return WheelScrollDirection.INVENTORY_POSITION_AWARE;
    }
}

