/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib;

import net.minecraft.client.resources.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MCDate {
    public static final String[] NAMES_DAYS = new String[]{"sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"};
    public static final String[] NAMES_MONTHS = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"};
    public static final int[] MONTH_LENGTHS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final long DAY_LENGTH = 24000L;
    private long totalDays = 0L;
    private int year = 0;
    private int month = 0;
    private long day = 0L;

    public MCDate(World world) {
        this(world.func_72820_D());
    }

    public MCDate(long time) {
        this.day = this.totalDays = (time + 24000L) / 24000L;
        while (this.day > (long)MONTH_LENGTHS[this.month]) {
            this.day -= (long)MONTH_LENGTHS[this.month];
            ++this.month;
            if (this.month != MONTH_LENGTHS.length) continue;
            this.month = 0;
            ++this.year;
        }
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month + 1;
    }

    public long getDay() {
        return this.day;
    }

    public long getTotalDays() {
        return this.totalDays;
    }

    public String getDayName() {
        return NAMES_DAYS[(int)this.day];
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedDayName() {
        return I18n.func_135052_a((String)("time.bookshelf.day." + this.getDayName() + ".name"), (Object[])new Object[0]);
    }

    public String getMonthName() {
        return NAMES_MONTHS[this.month];
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedMonthName() {
        return I18n.func_135052_a((String)("time.bookshelf.month." + this.getMonthName() + ".name"), (Object[])new Object[0]);
    }
}

