/*
 * Decompiled with CFR 0.152.
 */
package tehnut.harvest;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import tehnut.harvest.BlockStack;
import tehnut.harvest.Crop;
import tehnut.harvest.JsonConfigHandler;

public class HarvestConfig {
    private final transient Map<BlockStack, Crop> cropMap;
    private List<Crop> crops;
    private float exhaustionPerHarvest;
    private boolean additionalLogging;
    private boolean checkForCrops;

    public HarvestConfig(List<Crop> crops, float exhaustionPerHarvest, boolean additionalLogging, boolean checkForCrops) {
        this.crops = crops;
        this.exhaustionPerHarvest = exhaustionPerHarvest;
        this.additionalLogging = additionalLogging;
        this.checkForCrops = checkForCrops;
        this.cropMap = Maps.newHashMap();
    }

    public HarvestConfig() {
        this(JsonConfigHandler.handleDefaults(), 0.005f, false, false);
    }

    public void initCropMap() {
        for (Crop crop : this.crops) {
            this.cropMap.put(crop.getInitialBlock(), crop);
        }
    }

    public List<Crop> getCrops() {
        return this.crops;
    }

    public float getExhaustionPerHarvest() {
        return this.exhaustionPerHarvest;
    }

    public boolean shouldLog() {
        return this.additionalLogging;
    }

    public boolean runFirstStartSearch() {
        return this.checkForCrops;
    }

    public Map<BlockStack, Crop> getCropMap() {
        return this.cropMap;
    }
}

