/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.entries;

import com.rwtema.extrautils2.backend.MultiBlockStateBuilder;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUItemBlock;
import com.rwtema.extrautils2.backend.entries.BlockEntry;
import com.rwtema.extrautils2.backend.entries.Entry;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class MultiBlockEntry<T extends XUBlock>
extends Entry<List<T>> {
    public Class<? extends XUItemBlock> xuItemBlockClass = XUItemBlock.class;
    MultiBlockStateBuilder<T> builder;
    T mainBlock;
    XUItemBlock mainItem;

    public MultiBlockEntry(MultiBlockStateBuilder<T> builder, String name) {
        super(name);
        this.builder = builder;
    }

    public <S extends MultiBlockEntry<T>> S setItemBlockClass(Class<? extends XUItemBlock> xuItemBlockClass) {
        this.xuItemBlockClass = xuItemBlockClass;
        return (S)this;
    }

    @Override
    public List<T> initValue() {
        return this.builder.createBlocks(null);
    }

    @Override
    public void preInitRegister() {
        for (int i = 0; i < ((List)this.value).size(); ++i) {
            XUBlock t = (XUBlock)((List)this.value).get(i);
            if (i == 0) {
                t.setBlockName("extrautils2:" + this.name.toLowerCase(Locale.ENGLISH));
                Pair<XUBlock, ItemBlock> tItemBlockPair = BlockEntry.registerBlockItemCombo(t, this.xuItemBlockClass, this.name);
                this.mainBlock = (XUBlock)tItemBlockPair.getLeft();
                this.mainItem = (XUItemBlock)tItemBlockPair.getRight();
                continue;
            }
            t.setBlockName("extrautils2:" + this.name.toLowerCase(Locale.ENGLISH) + "." + i);
            this.xuItemBlockClass = XUItemBlock.class;
            BlockEntry.registerBlockItemCombo(t, null, this.name + "_" + i);
        }
    }

    @Override
    public ItemStack newStack(int amount, int meta) {
        return new ItemStack((Item)this.mainItem, amount, meta);
    }
}

