/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class NBTBuilder
implements INBTSerializable<NBTTagCompound>,
Supplier<NBTTagCompound> {
    private NBTTagCompound tag;

    public static NBTBuilder from(NBTTagCompound tag) {
        return new NBTBuilder(tag);
    }

    public NBTBuilder() {
        this(new NBTTagCompound());
    }

    public NBTBuilder(NBTTagCompound tag) {
        this.tag = (NBTTagCompound)Preconditions.checkNotNull((Object)tag);
    }

    public NBTBuilder setBlockPos(BlockPos pos) {
        return this.setBlockPos("position", pos);
    }

    public NBTBuilder setBlockPos(String name, BlockPos pos) {
        this.tag.func_74772_a(name, pos.func_177986_g());
        return this;
    }

    public NBTBuilder setTag(String name, INBTSerializable<?> tag) {
        return this.setTag(name, tag.serializeNBT());
    }

    public NBTBuilder setTag(String name, NBTBase tag) {
        this.tag.func_74782_a(name, tag);
        return this;
    }

    public NBTBuilder setInteger(String name, int i) {
        this.tag.func_74768_a(name, i);
        return this;
    }

    public NBTBuilder setByte(String name, byte b) {
        this.tag.func_74774_a(name, b);
        return this;
    }

    public NBTBuilder setShort(String name, short s) {
        this.tag.func_74777_a(name, s);
        return this;
    }

    public NBTBuilder setLong(String name, long l) {
        this.tag.func_74772_a(name, l);
        return this;
    }

    public NBTBuilder setFloat(String name, float f) {
        this.tag.func_74776_a(name, f);
        return this;
    }

    public NBTBuilder setDouble(String name, double d) {
        this.tag.func_74780_a(name, d);
        return this;
    }

    public NBTBuilder setString(String name, String str) {
        this.tag.func_74778_a(name, str);
        return this;
    }

    public NBTBuilder setByteArray(String name, byte[] b) {
        this.tag.func_74773_a(name, b);
        return this;
    }

    public NBTBuilder setIntArray(String name, int[] i) {
        this.tag.func_74783_a(name, i);
        return this;
    }

    public NBTBuilder setBoolean(String name, boolean b) {
        this.tag.func_74757_a(name, b);
        return this;
    }

    public BlockPos getBlockPos() {
        return this.getBlockPos("position");
    }

    public BlockPos getBlockPos(String name) {
        return BlockPos.func_177969_a((long)this.tag.func_74763_f(name));
    }

    public <N extends NBTBase> void getDeserialized(String name, INBTSerializable<N> serializable) {
        serializable.deserializeNBT(this.getTag(name));
    }

    public NBTBase getTag(String name) {
        return this.tag.func_74781_a(name);
    }

    public NBTTagCompound getCompound(String name) {
        return this.tag.func_74775_l(name);
    }

    public int getInteger(String name) {
        return this.tag.func_74762_e(name);
    }

    public byte getByte(String name) {
        return this.tag.func_74771_c(name);
    }

    public short getShort(String name) {
        return this.tag.func_74765_d(name);
    }

    public long getLong(String name) {
        return this.tag.func_74763_f(name);
    }

    public float getFloat(String name) {
        return this.tag.func_74760_g(name);
    }

    public double getDouble(String name) {
        return this.tag.func_74769_h(name);
    }

    public String getString(String name) {
        return this.tag.func_74779_i(name);
    }

    public byte[] getByteArray(String name) {
        return this.tag.func_74770_j(name);
    }

    public int[] getIntArray(String name) {
        return this.tag.func_74759_k(name);
    }

    public NBTTagList getList(String name, int type) {
        return this.tag.func_150295_c(name, type);
    }

    public boolean getBoolean(String name) {
        return this.tag.func_74767_n(name);
    }

    public byte getTagId(String name) {
        return this.tag.func_150299_b(name);
    }

    public boolean contains(String name) {
        return this.tag.func_74764_b(name);
    }

    public boolean contains(String name, int type) {
        return this.tag.func_150297_b(name, type);
    }

    public void remove(String name) {
        this.tag.func_82580_o(name);
    }

    public boolean isEmpty() {
        return this.tag.func_82582_d();
    }

    public NBTBuilder copy() {
        return NBTBuilder.from(this.tag.func_74737_b());
    }

    public NBTBuilder mergeWith(NBTBuilder other) {
        this.tag.func_179237_a(other.tag);
        return this;
    }

    public NBTTagCompound serializeNBT() {
        return this.tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (!this.tag.func_82582_d()) {
            throw new UnsupportedOperationException();
        }
        this.tag = nbt;
    }

    @Override
    public NBTTagCompound get() {
        return this.serializeNBT();
    }
}

