/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.compat.waila;

import elec332.core.api.info.IInfoDataAccessorBlock;
import elec332.core.api.info.IInformation;
import elec332.core.api.info.InfoMod;
import elec332.core.api.module.ElecModule;
import elec332.core.handler.InformationHandler;
import elec332.core.util.RayTraceHelper;
import elec332.core.world.WorldHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;

@ElecModule(owner="eleccore", name="WailaCompat", modDependencies="waila")
public class WailaCompatHandler
implements IWailaDataProvider {
    @ElecModule.Instance
    private static WailaCompatHandler instance;

    @ElecModule.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)(this.getClass().getCanonicalName() + ".register"));
    }

    public static void register(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)instance, Block.class);
        registrar.registerNBTProvider((IWailaDataProvider)instance, Block.class);
    }

    @Nonnull
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return accessor.getStack();
    }

    @Nonnull
    public List<String> getWailaHead(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currentTip;
    }

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, final List<String> currentTip, final IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getNBTData() != null && !accessor.getNBTData().func_74767_n("_nope_")) {
            InformationHandler.INSTANCE.addInformation(new IInformation(){

                @Override
                @Nonnull
                public InfoMod getProviderType() {
                    return InfoMod.WAILA;
                }

                @Override
                public void addInformation(String line) {
                    currentTip.add(line);
                }
            }, new IInfoDataAccessorBlock(){

                @Override
                @Nonnull
                public EntityPlayer getPlayer() {
                    return accessor.getPlayer();
                }

                @Override
                @Nonnull
                public World getWorld() {
                    return accessor.getWorld();
                }

                @Override
                @Nonnull
                public BlockPos getPos() {
                    return accessor.getPosition();
                }

                @Override
                @Nonnull
                public NBTTagCompound getData() {
                    return accessor.getNBTData();
                }

                @Override
                @Nonnull
                public EnumFacing getSide() {
                    return accessor.getSide();
                }

                @Override
                public Vec3d getHitVec() {
                    return accessor.getMOP() == null ? null : accessor.getMOP().field_72307_f;
                }

                @Override
                @Nonnull
                public IBlockState getBlockState() {
                    return accessor.getBlockState();
                }

                @Override
                @Nonnull
                public Block getBlock() {
                    return accessor.getBlock();
                }

                @Override
                @Nullable
                public TileEntity getTileEntity() {
                    return accessor.getTileEntity();
                }

                @Override
                public ItemStack getStack() {
                    return accessor.getStack();
                }

                @Override
                public RayTraceResult getRayTraceResult() {
                    return accessor.getMOP();
                }
            });
        }
        return currentTip;
    }

    @Nonnull
    public List<String> getWailaTail(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currentTip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(final EntityPlayerMP player, final TileEntity te, NBTTagCompound tag, final World world, final BlockPos pos) {
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        final NBTTagCompound fTag = tag;
        RayTraceResult rtr = RayTraceHelper.retraceBlock(world, pos, (EntityPlayer)player);
        if (rtr == null) {
            fTag.func_74757_a("_nope_", true);
            return fTag;
        }
        final RayTraceResult rtrF = rtr;
        return InformationHandler.INSTANCE.getInfoNBTData(fTag, te, player, new IInfoDataAccessorBlock(){
            private IBlockState ibs;

            @Override
            @Nonnull
            public EntityPlayer getPlayer() {
                return player;
            }

            @Override
            @Nonnull
            public World getWorld() {
                return world;
            }

            @Override
            @Nonnull
            public BlockPos getPos() {
                return pos;
            }

            @Override
            @Nonnull
            public NBTTagCompound getData() {
                return fTag;
            }

            @Override
            public Vec3d getHitVec() {
                return this.getRayTraceResult().field_72307_f;
            }

            @Override
            @Nonnull
            public EnumFacing getSide() {
                return this.getRayTraceResult().field_178784_b;
            }

            @Override
            @Nonnull
            public IBlockState getBlockState() {
                if (this.ibs == null) {
                    this.ibs = WorldHelper.getBlockState((IBlockAccess)this.getWorld(), this.getPos());
                }
                return this.ibs;
            }

            @Override
            @Nonnull
            public Block getBlock() {
                return this.getBlockState().func_177230_c();
            }

            @Override
            public TileEntity getTileEntity() {
                return te;
            }

            @Override
            public ItemStack getStack() {
                return null;
            }

            @Override
            public RayTraceResult getRayTraceResult() {
                return rtrF;
            }
        });
    }
}

