/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.controlpanel;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import malte0811.industrialwires.client.RawQuad;
import malte0811.industrialwires.client.gui.GuiPanelCreator;
import malte0811.industrialwires.controlpanel.ControlPanelNetwork;
import malte0811.industrialwires.controlpanel.IConfigurableComponent;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PanelUtils;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class Slider
extends PanelComponent
implements IConfigurableComponent {
    private static final float WIDTH = 0.0625f;
    private float length = 0.5f;
    private int color = 0xFFFF00;
    private boolean horizontal;
    private int out;
    @Nonnull
    private ControlPanelNetwork.RSChannel primary = ControlPanelNetwork.RSChannel.DEFAULT_CHANNEL;
    @Nonnull
    private ControlPanelNetwork.RSChannel secondary = ControlPanelNetwork.RSChannel.INVALID_CHANNEL;

    public Slider(float length, int color, boolean horizontal, @Nonnull ControlPanelNetwork.RSChannel primary, @Nonnull ControlPanelNetwork.RSChannel secondary) {
        this();
        this.color = color;
        this.length = length;
        this.horizontal = horizontal;
        this.primary = primary;
        this.secondary = secondary;
    }

    public Slider() {
        super("slider");
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound nbt, boolean toItem) {
        nbt.func_74768_a("color", this.color);
        nbt.func_74776_a("length", this.length);
        if (!toItem) {
            nbt.func_74768_a("output", this.out);
        }
        nbt.func_74768_a("rsId", this.primary.getController());
        nbt.func_74774_a("rsChannel", this.primary.getColor());
        nbt.func_74768_a("rsId2", this.secondary.getController());
        nbt.func_74774_a("rsChannel2", this.secondary.getColor());
        nbt.func_74757_a("horizontal", this.horizontal);
    }

    @Override
    protected void readCustomNBT(NBTTagCompound nbt) {
        this.color = nbt.func_74762_e("color");
        this.length = nbt.func_74760_g("length");
        this.horizontal = nbt.func_74767_n("horizontal");
        this.out = nbt.func_74762_e("output");
        int rsController = nbt.func_74762_e("rsId");
        byte rsColor = nbt.func_74771_c("rsChannel");
        this.primary = new ControlPanelNetwork.RSChannel(rsController, rsColor);
        if (nbt.func_74764_b("rsId2")) {
            rsController = nbt.func_74762_e("rsId2");
            rsColor = nbt.func_74771_c("rsChannel2");
            this.secondary = new ControlPanelNetwork.RSChannel(rsController, rsColor);
        } else {
            this.secondary = ControlPanelNetwork.RSChannel.INVALID_CHANNEL;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<RawQuad> getQuads() {
        ArrayList<RawQuad> ret = new ArrayList<RawQuad>();
        float xSize = this.horizontal ? this.length : 0.0625f;
        float ySize = this.horizontal ? 0.0625f : this.length;
        PanelUtils.addColoredQuad(ret, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, ySize), new Vector3f(xSize, 0.0f, ySize), new Vector3f(xSize, 0.0f, 0.0f), EnumFacing.UP, GRAY);
        float[] color = new float[4];
        color[3] = 1.0f;
        for (int i = 0; i < 3; ++i) {
            color[i] = (float)(this.color >> 8 * (2 - i) & 0xFF) / 255.0f * (0.5f + (float)this.out / 255.0f / 2.0f);
        }
        float val = this.horizontal ? (float)this.out / 255.0f * (this.length - 0.0625f) : (1.0f - (float)this.out / 255.0f) * (this.length - 0.0625f);
        PanelUtils.addColoredBox(color, GRAY, null, new Vector3f(this.horizontal ? val : 0.0f, 0.0f, this.horizontal ? 0.0f : val), new Vector3f(0.0625f, this.getHeight(), 0.0625f), ret, false);
        if (this.out > 0) {
            ((RawQuad)ret.get((int)1)).light = 1044735;
        }
        return ret;
    }

    @Override
    @Nonnull
    public PanelComponent copyOf() {
        Slider ret = new Slider(this.length, this.color, this.horizontal, this.primary, this.secondary);
        ret.out = this.out;
        ret.setX(this.x);
        ret.setY(this.y);
        ret.panelHeight = this.panelHeight;
        return ret;
    }

    @Override
    @Nonnull
    public AxisAlignedBB getBlockRelativeAABB() {
        if (this.aabb == null) {
            this.aabb = new AxisAlignedBB((double)this.x, 0.0, (double)this.y, (double)(this.x + (this.horizontal ? this.length : 0.0625f)), (double)this.getHeight(), (double)(this.y + (this.horizontal ? 0.0625f : this.length)));
        }
        return this.aabb;
    }

    @Override
    public void interactWith(Vec3d hitRelative, EntityPlayerMP player) {
        double pos = this.horizontal ? hitRelative.field_72450_a : (double)this.length - hitRelative.field_72449_c;
        int newLevel = (int)Math.min(pos * 256.0 / (double)this.length, 255.0);
        if (newLevel != this.out) {
            this.setOut(newLevel);
        }
    }

    @Override
    public void update() {
    }

    @Override
    public void setNetwork(ControlPanelNetwork net) {
        super.setNetwork(net);
        this.network.setOutputs(this, new ControlPanelNetwork.RSChannelState(this.primary, (byte)(this.out >> 4)));
        this.network.setOutputs(this, new ControlPanelNetwork.RSChannelState(this.secondary, (byte)(this.out & 0xF)));
    }

    @Override
    public float getHeight() {
        return 0.03125f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInGUI(GuiPanelCreator gui) {
        this.renderInGUIDefault(gui, -3092272);
        double middleX = (double)this.getX() + (this.horizontal ? (double)this.length : 0.0625) / 2.0;
        double middleY = (double)this.getY() + (this.horizontal ? 0.0625 : (double)this.length) / 2.0;
        int left = gui.getX0() + (int)((middleX - 0.03125) * (double)gui.panelSize);
        int right = gui.getX0() + (int)((middleX + 0.03125) * (double)gui.panelSize);
        int top = gui.getY0() + (int)((middleY - 0.03125) * (double)gui.panelSize);
        int bottom = gui.getY0() + (int)((middleY + 0.03125) * (double)gui.panelSize);
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)(0xFF000000 | this.color));
    }

    public void setOut(int value) {
        this.network.setOutputs(this, new ControlPanelNetwork.RSChannelState(this.primary, (byte)(value >> 4)));
        this.network.setOutputs(this, new ControlPanelNetwork.RSChannelState(this.secondary, (byte)(value & 0xF)));
        this.out = value;
        this.panel.func_70296_d();
        this.panel.triggerRenderUpdate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Slider slider = (Slider)o;
        if (Float.compare(slider.length, this.length) != 0) {
            return false;
        }
        if (this.color != slider.color) {
            return false;
        }
        if (this.horizontal != slider.horizontal) {
            return false;
        }
        if (this.out != slider.out) {
            return false;
        }
        if (!this.primary.equals(slider.primary)) {
            return false;
        }
        return this.secondary.equals(slider.secondary);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.length != 0.0f ? Float.floatToIntBits(this.length) : 0);
        result = 31 * result + this.color;
        result = 31 * result + (this.horizontal ? 1 : 0);
        result = 31 * result + this.out;
        result = 31 * result + this.primary.hashCode();
        result = 31 * result + this.secondary.hashCode();
        return result;
    }

    @Override
    public void applyConfigOption(IConfigurableComponent.ConfigType type, int id, NBTBase value) {
        switch (type) {
            case BOOL: {
                this.horizontal = ((NBTTagByte)value).func_150290_f() != 0;
                break;
            }
            case RS_CHANNEL: {
                if (id == 0) {
                    this.primary = this.primary.withColor(value);
                    break;
                }
                this.secondary = this.secondary.withColor(value);
                break;
            }
            case INT: {
                if (id == 0) {
                    this.primary = this.primary.withController(value);
                    break;
                }
                this.secondary = this.secondary.withController(value);
                break;
            }
            case FLOAT: {
                if (id < 3) {
                    this.color = PanelUtils.setColor(this.color, id, value);
                    break;
                }
                this.length = this.scaleToRangePercent(((NBTTagFloat)value).func_150288_h(), 0.125f, 1.0f);
            }
        }
    }

    private float scaleToRangePercent(float x, float min, float max) {
        return min + x / 100.0f * (max - min);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigName(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case BOOL: {
                return I18n.func_135052_a((String)"industrialwires.tooltip.horizontal", (Object[])new Object[0]);
            }
            case RS_CHANNEL: 
            case INT: {
                return null;
            }
            case FLOAT: {
                return I18n.func_135052_a((String)("industrialwires.desc." + (id == 0 ? "red" : (id == 1 ? "green" : (id == 2 ? "blue" : "length")))), (Object[])new Object[0]);
            }
        }
        return "INVALID";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigDescription(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case BOOL: {
                return null;
            }
            case RS_CHANNEL: {
                return I18n.func_135052_a((String)("industrialwires.desc.rschannel_info" + (id == 0 ? "" : "2")), (Object[])new Object[0]);
            }
            case INT: {
                return I18n.func_135052_a((String)("industrialwires.desc.rsid_info" + (id == 0 ? "" : "2")), (Object[])new Object[0]);
            }
            case FLOAT: {
                return null;
            }
        }
        return "INVALID?";
    }

    @Override
    public IConfigurableComponent.RSColorConfig[] getRSChannelOptions() {
        return new IConfigurableComponent.RSColorConfig[]{new IConfigurableComponent.RSColorConfig("channel", 0, 0, this.primary.getColor(), true), new IConfigurableComponent.RSColorConfig("channel2", 30, 0, this.secondary.getColor(), true)};
    }

    @Override
    public IConfigurableComponent.IntConfig[] getIntegerOptions() {
        return new IConfigurableComponent.IntConfig[]{new IConfigurableComponent.IntConfig("rsId", 0, 30, this.primary.getController(), 2, false), new IConfigurableComponent.IntConfig("rsId2", 30, 30, this.secondary.getController(), 2, true)};
    }

    @Override
    public IConfigurableComponent.BoolConfig[] getBooleanOptions() {
        return new IConfigurableComponent.BoolConfig[]{new IConfigurableComponent.BoolConfig("horizontal", 0, 40, this.horizontal)};
    }

    @Override
    public IConfigurableComponent.FloatConfig[] getFloatOptions() {
        float[] color = PanelUtils.getFloatColor(true, this.color);
        int x = 70;
        int yOffset = 10;
        return new IConfigurableComponent.FloatConfig[]{new IConfigurableComponent.FloatConfig("red", x, yOffset + 20, Float.valueOf(color[0]), 60), new IConfigurableComponent.FloatConfig("green", x, yOffset + 40, Float.valueOf(color[1]), 60), new IConfigurableComponent.FloatConfig("blue", x, yOffset + 60, Float.valueOf(color[2]), 60), new IConfigurableComponent.FloatConfig("length", x, yOffset, Float.valueOf((this.length - 0.125f) / 0.875f), 60)};
    }

    @Override
    public int getColor() {
        return this.color;
    }
}

