/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.controlpanel;

import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.controlpanel.BlockTypes_Panel;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PanelUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PropertyComponents
implements IUnlistedProperty<PanelRenderProperties> {
    public static PropertyComponents INSTANCE = new PropertyComponents();

    public String getName() {
        return "components";
    }

    public boolean isValid(PanelRenderProperties value) {
        return value != null;
    }

    public Class<PanelRenderProperties> getType() {
        return PanelRenderProperties.class;
    }

    public String valueToString(PanelRenderProperties value) {
        return value.toString();
    }

    public static class AABBPanelProperties
    extends PanelRenderProperties {
        private AxisAlignedBB aabb;
        private int lastHash;

        public AABBPanelProperties() {
            super(1);
        }

        public AxisAlignedBB getPanelBoundingBox() {
            if (this.size() < 1) {
                this.aabb = Block.field_185505_j;
            } else if (this.aabb != null || ((PanelComponent)this.get(0)).hashCode() != this.lastHash) {
                this.aabb = this.getPanelBoundingBox((PanelComponent)this.get(0));
                this.lastHash = ((PanelComponent)this.get(0)).hashCode();
            }
            return this.aabb;
        }

        @Override
        public PanelComponent set(int index, PanelComponent pc) {
            AxisAlignedBB aabb = pc.getBlockRelativeAABB();
            pc.setX((float)((1.0 - aabb.field_72336_d + aabb.field_72340_a) / 2.0));
            pc.setY((float)((1.0 - aabb.field_72334_f + aabb.field_72339_c) / 2.0));
            return super.set(index, pc);
        }

        @Override
        public boolean add(PanelComponent pc) {
            AxisAlignedBB aabb = pc.getBlockRelativeAABB();
            pc.setX((float)((1.0 - aabb.field_72336_d + aabb.field_72340_a) / 2.0));
            pc.setY((float)((1.0 - aabb.field_72334_f + aabb.field_72339_c) / 2.0));
            return super.add(pc);
        }

        private AxisAlignedBB getPanelBoundingBox(PanelComponent element) {
            AxisAlignedBB compAABB = element.getBlockRelativeAABB();
            float height = 0.375f;
            double width = 3.0 * (compAABB.field_72336_d - compAABB.field_72340_a);
            double length = 3.0 * (compAABB.field_72334_f - compAABB.field_72339_c);
            width = MathHelper.func_151237_a((double)width, (double)0.4375, (double)1.0);
            length = MathHelper.func_151237_a((double)length, (double)0.4375, (double)1.0);
            double minX = (1.0 - width) / 2.0;
            double minZ = (1.0 - length) / 2.0;
            return new AxisAlignedBB(minX, 0.0, minZ, minX + width, (double)height, minZ + length);
        }

        @Override
        public float getHeight() {
            return (float)this.getPanelBoundingBox().field_72337_e;
        }
    }

    public static class PanelRenderProperties
    extends ArrayList<PanelComponent> {
        private EnumFacing facing = EnumFacing.NORTH;
        private float height = 0.5f;
        private EnumFacing top = EnumFacing.UP;
        private float angle = 0.0f;
        private Matrix4 topTransform;
        private Matrix4 topTransformInverse;
        private Matrix4 baseTransform;
        private ItemStack textureSource = new ItemStack((Block)IndustrialWires.panel, 1, BlockTypes_Panel.DUMMY.ordinal());

        public PanelRenderProperties() {
        }

        public PanelRenderProperties(int length) {
            super(length);
        }

        @Override
        public String toString() {
            StringBuilder ret = new StringBuilder("[");
            for (int i = 0; i < this.size(); ++i) {
                ret.append(this.get(i));
                if (i >= this.size() - 1) continue;
                ret.append(", ");
            }
            return ret + "]";
        }

        @Nonnull
        public Matrix4 getPanelTopTransform() {
            if (this.topTransform == null) {
                this.topTransform = this.getPanelBaseTransform().copy().translate(0.0, (double)this.getHeight(), 0.5).rotate((double)this.angle, 1.0, 0.0, 0.0).translate(0.0, 0.0, -0.5);
            }
            return this.topTransform;
        }

        @Nonnull
        public Matrix4 getPanelTopTransformInverse() {
            if (this.topTransformInverse == null) {
                this.topTransformInverse = this.getPanelTopTransform().copy();
                this.topTransformInverse.invert();
            }
            return this.topTransformInverse;
        }

        @SideOnly(value=Side.CLIENT)
        public void transformGLForTop(BlockPos panelPos) {
            double px = (double)panelPos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b;
            double py = (double)panelPos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c;
            double pz = (double)panelPos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d;
            GlStateManager.func_179137_b((double)(px + 0.5), (double)(py + 0.5), (double)(pz + 0.5));
            switch (this.top) {
                case DOWN: {
                    GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(-this.facing.func_185119_l()), (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case UP: {
                    GlStateManager.func_179114_b((float)(180.0f - this.facing.func_185119_l()), (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case NORTH: 
                case SOUTH: 
                case WEST: 
                case EAST: {
                    GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)this.top.func_185119_l(), (float)0.0f, (float)0.0f, (float)1.0f);
                }
            }
            GlStateManager.func_179137_b((double)-0.5, (double)((double)this.getHeight() - 0.5), (double)0.0);
            GlStateManager.func_179114_b((float)((float)((double)(this.angle * 180.0f) / Math.PI)), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.5);
        }

        @Nonnull
        public Matrix4 getPanelBaseTransform() {
            if (this.baseTransform == null) {
                this.baseTransform = new Matrix4();
                this.baseTransform.translate(0.5, 0.5, 0.5);
                switch (this.top) {
                    case DOWN: {
                        this.baseTransform.rotate(Math.PI, 0.0, 0.0, 1.0);
                    }
                    case UP: {
                        this.baseTransform.rotate((double)(-this.facing.func_185119_l()) * Math.PI / 180.0 + Math.PI, 0.0, 1.0, 0.0);
                        break;
                    }
                    case NORTH: 
                    case SOUTH: 
                    case WEST: 
                    case EAST: {
                        this.baseTransform.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                        this.baseTransform.rotate((double)this.top.func_185119_l() * Math.PI / 180.0, 0.0, 0.0, 1.0);
                    }
                }
                this.baseTransform.translate(-0.5, -0.5, -0.5);
            }
            return this.baseTransform;
        }

        public float getMaxHeight() {
            float max = this.getPanelMaxHeight();
            for (PanelComponent pc : this) {
                float h = PanelUtils.getHeightWithComponent(pc, this.angle, this.getHeight());
                if (!(h > max)) continue;
                max = h;
            }
            return max;
        }

        public PanelRenderProperties copyOf() {
            PanelRenderProperties ret = new PanelRenderProperties(this.size());
            for (PanelComponent pc : this) {
                ret.add(pc.copyOf());
            }
            ret.facing = this.facing;
            ret.top = this.top;
            ret.angle = this.angle;
            ret.textureSource = this.textureSource;
            return ret;
        }

        public float getPanelMaxHeight() {
            return (float)((double)this.getHeight() + Math.abs(Math.tan(this.angle) / 2.0));
        }

        private void resetMatrixes() {
            this.baseTransform = null;
            this.topTransformInverse = null;
            this.topTransform = null;
        }

        public EnumFacing getFacing() {
            return this.facing;
        }

        public void setFacing(EnumFacing facing) {
            if (facing != this.facing) {
                this.facing = facing;
                this.resetMatrixes();
            }
        }

        public void setTextureSource(ItemStack textureSource) {
            if (textureSource.func_77973_b() instanceof ItemBlock) {
                this.textureSource = textureSource;
            }
        }

        public ItemStack getTextureSource() {
            return this.textureSource;
        }

        public float getHeight() {
            return this.height;
        }

        public void setHeight(float height) {
            if (height != this.height) {
                this.height = height;
                this.resetMatrixes();
            }
        }

        public EnumFacing getTop() {
            return this.top;
        }

        public void setTop(EnumFacing top) {
            if (top != this.top) {
                this.top = top;
                this.resetMatrixes();
            }
        }

        public float getAngle() {
            return this.angle;
        }

        public void setAngle(float angle) {
            if (angle != this.angle) {
                this.angle = angle;
                this.resetMatrixes();
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PanelRenderProperties that = (PanelRenderProperties)o;
            if (Float.compare(that.height, this.height) != 0) {
                return false;
            }
            if (Float.compare(that.angle, this.angle) != 0) {
                return false;
            }
            if (this.facing != that.facing) {
                return false;
            }
            if (this.top != that.top) {
                return false;
            }
            return ItemStack.func_77989_b((ItemStack)this.textureSource, (ItemStack)that.textureSource);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.facing.hashCode();
            result = 31 * result + (this.height != 0.0f ? Float.floatToIntBits(this.height) : 0);
            result = 31 * result + this.top.hashCode();
            result = 31 * result + (this.angle != 0.0f ? Float.floatToIntBits(this.angle) : 0);
            return result;
        }
    }
}

