/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.client;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.ManualPageMultiblock;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import malte0811.industrialwires.CommonProxy;
import malte0811.industrialwires.IEObjects;
import malte0811.industrialwires.IWConfig;
import malte0811.industrialwires.IWPotions;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.controlpanel.BlockTypes_Panel;
import malte0811.industrialwires.blocks.controlpanel.TileEntityPanelCreator;
import malte0811.industrialwires.blocks.controlpanel.TileEntityRSPanel;
import malte0811.industrialwires.blocks.converter.TileEntityMechMB;
import malte0811.industrialwires.blocks.hv.TileEntityJacobsLadder;
import malte0811.industrialwires.blocks.hv.TileEntityMarx;
import malte0811.industrialwires.client.IWTickableSound;
import malte0811.industrialwires.client.gui.GuiPanelComponent;
import malte0811.industrialwires.client.gui.GuiPanelCreator;
import malte0811.industrialwires.client.gui.GuiRSPanelConn;
import malte0811.industrialwires.client.gui.GuiRenameKey;
import malte0811.industrialwires.client.manual.TextSplitter;
import malte0811.industrialwires.client.multiblock_io_model.MBIOModelLoader;
import malte0811.industrialwires.client.panelmodel.PanelModelLoader;
import malte0811.industrialwires.client.render.EntityRenderBrokenPart;
import malte0811.industrialwires.client.render.Shaders;
import malte0811.industrialwires.client.render.TileRenderJacobsLadder;
import malte0811.industrialwires.client.render.TileRenderMarx;
import malte0811.industrialwires.client.render.TileRenderMechMB;
import malte0811.industrialwires.compat.Compat;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.crafting.IC2TRHelper;
import malte0811.industrialwires.entities.EntityBrokenPart;
import malte0811.industrialwires.hv.MarxOreHandler;
import malte0811.industrialwires.hv.MultiblockMarx;
import malte0811.industrialwires.items.ItemIC2Coil;
import malte0811.industrialwires.items.ItemPanelComponent;
import malte0811.industrialwires.mech_mb.Material;
import malte0811.industrialwires.mech_mb.MechEnergy;
import malte0811.industrialwires.mech_mb.MechMBPart;
import malte0811.industrialwires.mech_mb.MechPartCommutator4Phase;
import malte0811.industrialwires.mech_mb.MechPartFlywheel;
import malte0811.industrialwires.mech_mb.MechPartFourElectrodes;
import malte0811.industrialwires.mech_mb.MechPartSingleCoil;
import malte0811.industrialwires.util.CommandIWClient;
import malte0811.industrialwires.util.ConversionUtil;
import malte0811.industrialwires.util.MiscUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private static ISound playingTinnitus = null;
    private Map<BlockPos, List<ISound>> playingSounds = new HashMap<BlockPos, List<ISound>>();

    @Override
    public void preInit() {
        super.preInit();
        OBJLoader.INSTANCE.addDomain("industrialwires");
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new PanelModelLoader());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new MBIOModelLoader());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityJacobsLadder.class, (TileEntitySpecialRenderer)new TileRenderJacobsLadder());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMarx.class, (TileEntitySpecialRenderer)new TileRenderMarx());
        TileRenderMechMB tesr = new TileRenderMechMB();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMechMB.class, (TileEntitySpecialRenderer)tesr);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)tesr);
        RenderingRegistry.registerEntityRenderingHandler(EntityBrokenPart.class, EntityRenderBrokenPart::new);
        Shaders.initShaders(true);
    }

    @Override
    public void postInit() {
        super.postInit();
        ManualInstance m = ManualHelper.getManual();
        boolean uni = m.fontRenderer.func_82883_a();
        m.fontRenderer.func_78264_a(true);
        m.entryRenderPre();
        ManualPages.PositionedItemStack[][] wireRecipes = new ManualPages.PositionedItemStack[3][10];
        int xBase = 15;
        Ingredient copperCable = IC2TRHelper.getStack("cable", "type:copper,insulation:0");
        Object2IntLinkedOpenHashMap copperCables = new Object2IntLinkedOpenHashMap();
        for (ItemStack itemStack : copperCable.func_193365_a()) {
            copperCables.put((Object)itemStack, 1);
        }
        copperCables.put((Object)new ItemStack(IEObjects.itemWireCoil, 1, 0), 8);
        ArrayList copperCableList = new ArrayList(copperCables.keySet());
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                wireRecipes[0][3 * i + j] = new ManualPages.PositionedItemStack(copperCableList, 18 * i + xBase, 18 * j);
            }
        }
        ItemStack copperCoil = new ItemStack((Item)IndustrialWires.coil, 1, 1);
        ItemIC2Coil.setLength(copperCoil, 9);
        wireRecipes[0][9] = new ManualPages.PositionedItemStack((Object)copperCoil, 72 + xBase, 18);
        Random r = new Random();
        for (int i = 1; i < 3; ++i) {
            int lengthSum = 0;
            for (int j1 = 0; j1 < 3; ++j1) {
                for (int j2 = 0; j2 < 3; ++j2) {
                    if (r.nextDouble() > 1.0 / (1.0 + (double)copperCables.size())) {
                        ItemStack chosen = (ItemStack)copperCableList.get(r.nextInt(copperCables.size()));
                        lengthSum += copperCables.getInt((Object)chosen);
                        wireRecipes[i][3 * j1 + j2] = new ManualPages.PositionedItemStack((Object)chosen, 18 * j1 + xBase, 18 * j2);
                        continue;
                    }
                    int length = r.nextInt(99) + 1;
                    copperCoil = new ItemStack((Item)IndustrialWires.coil, 1, 1);
                    ItemIC2Coil.setLength(copperCoil, length);
                    wireRecipes[i][3 * j1 + j2] = new ManualPages.PositionedItemStack((Object)copperCoil, 18 * j1 + xBase, 18 * j2);
                    lengthSum += length;
                }
            }
            copperCoil = new ItemStack((Item)IndustrialWires.coil);
            ItemIC2Coil.setLength(copperCoil, lengthSum);
            wireRecipes[i][9] = new ManualPages.PositionedItemStack((Object)copperCoil, 72 + xBase, 18);
        }
        TextSplitter splitter = new TextSplitter(m);
        splitter.addSpecialPage(0, 0, 10, s -> new ManualPages.CraftingMulti(m, s, (Object[])wireRecipes));
        String text = I18n.func_135052_a((String)"ie.manual.entry.industrialwires.wires", (Object[])new Object[0]);
        splitter.split(text);
        List<IManualPage> entry = splitter.toManualEntry();
        m.addEntry("industrialwires.wires", "industrialwires", entry.toArray(new IManualPage[0]));
        if (IndustrialWires.hasIC2 && IndustrialWires.mechConv != null) {
            m.addEntry("industrialwires.mechConv", "industrialwires", new IManualPage[]{new ManualPages.Crafting(m, "industrialwires.mechConv0", new Object[]{new ItemStack((Block)IndustrialWires.mechConv, 1, 1)}), new ManualPages.Crafting(m, "industrialwires.mechConv1", new Object[]{new ItemStack((Block)IndustrialWires.mechConv, 1, 2)}), new ManualPages.Crafting(m, "industrialwires.mechConv2", new Object[]{new ItemStack((Block)IndustrialWires.mechConv, 1, 0)})});
        }
        this.addUnblockableSounds(IndustrialWires.TINNITUS, IndustrialWires.TURN_FAST, IndustrialWires.TURN_SLOW);
        ClientUtils.mc().getItemColors().func_186730_a((stack, pass) -> {
            PanelComponent pc;
            if (pass == 1 && (pc = ItemPanelComponent.componentFromStack(stack)) != null) {
                return 0xFF000000 | pc.getColor();
            }
            return -1;
        }, new Item[]{IndustrialWires.panelComponent});
        Config.manual_doubleA.put("iwJacobsUsage", IWConfig.HVStuff.jacobsUsageWatt);
        Config.manual_double.put("iwFluxPerJoule", ConversionUtil.ifPerJoule());
        Config.manual_int.put("iwKeysOnRing", IWConfig.maxKeysOnRing);
        m.addEntry("industrialwires.jacobs", "industrialwires", new IManualPage[]{new ManualPages.CraftingMulti(m, "industrialwires.jacobs0", new Object[]{new ItemStack((Block)IndustrialWires.jacobsLadder, 1, 0), new ItemStack((Block)IndustrialWires.jacobsLadder, 1, 1), new ItemStack((Block)IndustrialWires.jacobsLadder, 1, 2)}), new ManualPages.Text(m, "industrialwires.jacobs1")});
        String text2 = I18n.func_135052_a((String)"ie.manual.entry.industrialwires.intro", (Object[])new Object[0]);
        splitter = new TextSplitter(m);
        splitter.addSpecialPage(0, 0, 9, s -> new ManualPages.Crafting(m, s, new Object[]{new ItemStack((Block)IndustrialWires.panel, 1, BlockTypes_Panel.DUMMY.ordinal())}));
        splitter.addSpecialPage(1, 0, 9, s -> new ManualPages.Crafting(m, s, new Object[]{new ItemStack((Block)IndustrialWires.panel, 1, BlockTypes_Panel.UNFINISHED.ordinal())}));
        splitter.split(text2);
        m.addEntry("industrialwires.intro", "control_panels", splitter.toManualEntry().toArray(new IManualPage[0]));
        m.addEntry("industrialwires.panel_creator", "control_panels", new IManualPage[]{new ManualPages.Crafting(m, "industrialwires.panel_creator0", new Object[]{new ItemStack((Block)IndustrialWires.panel, 1, BlockTypes_Panel.CREATOR.ordinal())}), new ManualPages.Text(m, "industrialwires.panel_creator1"), new ManualPages.Text(m, "industrialwires.panel_creator2")});
        text2 = I18n.func_135052_a((String)"ie.manual.entry.industrialwires.redstone", (Object[])new Object[0]);
        splitter = new TextSplitter(m);
        splitter.addSpecialPage(-1, 0, Compat.enableOtherRS ? 9 : 12, s -> new ManualPages.CraftingMulti(m, s, new Object[]{new ResourceLocation("industrialwires", "control_panel_rs_other"), new ResourceLocation("industrialwires", "control_panel_rs_wire")}));
        splitter.split(text2);
        m.addEntry("industrialwires.redstone", "control_panels", splitter.toManualEntry().toArray(new IManualPage[0]));
        m.addEntry("industrialwires.components", "control_panels", new IManualPage[]{new ManualPages.Text(m, "industrialwires.components.general"), new ManualPages.Crafting(m, "industrialwires.button", new Object[]{new ItemStack((Item)IndustrialWires.panelComponent, 1, 0)}), new ManualPages.Crafting(m, "industrialwires.label", new Object[]{new ItemStack((Item)IndustrialWires.panelComponent, 1, 1)}), new ManualPages.Crafting(m, "industrialwires.indicator_light", new Object[]{new ItemStack((Item)IndustrialWires.panelComponent, 1, 2)}), new ManualPages.Crafting(m, "industrialwires.slider", new Object[]{new ItemStack((Item)IndustrialWires.panelComponent, 1, 3)}), new ManualPages.CraftingMulti(m, "industrialwires.toggle_switch", new Object[]{new ItemStack((Item)IndustrialWires.panelComponent, 1, 5), new ItemStack((Item)IndustrialWires.panelComponent, 1, 6)}), new ManualPages.Text(m, "industrialwires.toggle_switch1"), new ManualPages.Crafting(m, "industrialwires.variac", new Object[]{new ItemStack((Item)IndustrialWires.panelComponent, 1, 4)}), new ManualPages.CraftingMulti(m, "industrialwires.lock", new Object[]{new ItemStack((Item)IndustrialWires.panelComponent, 1, 7), new ItemStack((Item)IndustrialWires.key)}), new ManualPages.Crafting(m, "industrialwires.lock1", new Object[]{new ItemStack((Item)IndustrialWires.key, 1, 2)}), new ManualPages.Crafting(m, "industrialwires.panel_meter", new Object[]{new ItemStack((Item)IndustrialWires.panelComponent, 1, 8)}), new ManualPages.Crafting(m, "industrialwires.7seg", new Object[]{new ItemStack((Item)IndustrialWires.panelComponent, 1, 9)})});
        List<MarxOreHandler.OreInfo> ores = MarxOreHandler.getRecipes();
        text2 = I18n.func_135052_a((String)"ie.manual.entry.industrialwires.marx", (Object[])new Object[0]);
        for (int i = 0; i < ores.size(); ++i) {
            MarxOreHandler.OreInfo curr = ores.get(i);
            if (curr.exampleInput.isEmpty()) continue;
            text2 = text2 + I18n.func_135052_a((String)"industrialwires.desc.input", (Object[])new Object[0]) + ": \u00a7l" + curr.exampleInput.get(0).func_82833_r() + "\u00a7r<br>";
            text2 = text2 + I18n.func_135052_a((String)"industrialwires.desc.output", (Object[])new Object[0]) + ": " + Utils.formatDouble((double)curr.maxYield, (String)"0.#") + "x" + curr.output.get().func_82833_r() + "<br>";
            if (curr.outputSmall != null && !curr.outputSmall.get().func_190926_b()) {
                text2 = text2 + I18n.func_135052_a((String)"industrialwires.desc.alt", (Object[])new Object[0]) + ": " + curr.smallMax + "x" + curr.outputSmall.get().func_82833_r() + "<br>";
            }
            text2 = text2 + I18n.func_135052_a((String)"industrialwires.desc.ideal_e", (Object[])new Object[0]) + ": " + Utils.formatDouble((double)(curr.avgEnergy * MarxOreHandler.defaultEnergy / 1000.0), (String)"0.#") + " kJ<br><br>";
        }
        splitter = new TextSplitter(m);
        splitter.addSpecialPage(0, 0, 6, s -> new ManualPageMultiblock(m, s, (MultiblockHandler.IMultiblock)MultiblockMarx.INSTANCE));
        splitter.split(text2);
        List<IManualPage> marxEntry = splitter.toManualEntry();
        m.addEntry("industrialwires.marx", "industrialwires", marxEntry.toArray(new IManualPage[0]));
        text2 = I18n.func_135052_a((String)"ie.manual.entry.industrialwires.mech_mb", (Object[])new Object[0]);
        splitter = new TextSplitter(m);
        splitter.addSpecialPage(0, 0, 8, s -> new ManualPageMultiblock(m, s, MiscUtils.getMBFromName(MechMBPart.EXAMPLE_MECHMB_LOC.toString())));
        splitter.split(text2);
        List<IManualPage> mechMBEntry = splitter.toManualEntry();
        m.addEntry("industrialwires.mech_mb", "industrialwires", mechMBEntry.toArray(new IManualPage[0]));
        ArrayList<String[]> flywheelTableList = new ArrayList<String[]>(1 + Material.values().length);
        flywheelTableList.add(new String[]{"industrialwires.desc.material", "industrialwires.desc.inertia", "industrialwires.desc.max_speed"});
        for (Material mat : Material.values()) {
            MechPartFlywheel f = new MechPartFlywheel(mat);
            flywheelTableList.add(new String[]{mat.oreName(), Utils.formatDouble((double)f.getInertia(), (String)"0.#"), Utils.formatDouble((double)f.getMaxSpeed(), (String)"0.#")});
        }
        String[][] flywheelTable = (String[][])flywheelTableList.toArray((T[])new String[0][]);
        text2 = I18n.func_135052_a((String)"ie.manual.entry.industrialwires.mech_mb_parts", (Object[])new Object[0]);
        splitter = new TextSplitter(m);
        splitter.addSpecialPage(0, 0, 10, s -> new ManualPageMultiblock(m, s, MechMBPart.getManualMBForPart(MechPartFlywheel.class)));
        splitter.addSpecialPage(1, 0, 1, s -> new ManualPages.Table(m, "", flywheelTable, true));
        splitter.addSpecialPage(2, 0, 10, s -> new ManualPageMultiblock(m, s, MechMBPart.getManualMBForPart(MechPartSingleCoil.class)));
        splitter.addSpecialPage(3, 0, 10, s -> new ManualPageMultiblock(m, s, MechMBPart.getManualMBForPart(MechPartFourElectrodes.class)));
        if (IWConfig.MechConversion.allowMBEU()) {
            text2 = text2 + I18n.func_135052_a((String)"ie.manual.entry.industrialwires.mech_mb_parts.commutator", (Object[])new Object[0]);
            splitter.addSpecialPage(4, 0, 10, s -> new ManualPageMultiblock(m, s, MechMBPart.getManualMBForPart(MechPartCommutator4Phase.class)));
        }
        splitter.split(text2);
        List<IManualPage> partsEntry = splitter.toManualEntry();
        m.addEntry("industrialwires.mech_mb_parts", "industrialwires", partsEntry.toArray(new IManualPage[0]));
        m.entryRenderPost();
        m.fontRenderer.func_78264_a(uni);
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandIWClient());
    }

    private void addUnblockableSounds(SoundEvent ... sounds) {
        int oldLength = Config.IEConfig.Tools.earDefenders_SoundBlacklist.length;
        Config.IEConfig.Tools.earDefenders_SoundBlacklist = Arrays.copyOf(Config.IEConfig.Tools.earDefenders_SoundBlacklist, oldLength + sounds.length);
        for (int i = 0; i < sounds.length; ++i) {
            Config.IEConfig.Tools.earDefenders_SoundBlacklist[oldLength + i] = sounds[i].func_187503_a().toString();
        }
    }

    @Override
    public void startTinnitus() {
        Minecraft mc = Minecraft.func_71410_x();
        if (playingTinnitus == null || !mc.func_147118_V().func_147692_c(playingTinnitus)) {
            playingTinnitus = this.getTinnitus();
            mc.func_147118_V().func_147682_a(playingTinnitus);
        }
    }

    private ISound getTinnitus() {
        final Minecraft mc = Minecraft.func_71410_x();
        return new MovingSound(IndustrialWires.TINNITUS, SoundCategory.PLAYERS){

            public void func_73660_a() {
                if (mc.field_71439_g.func_70660_b((Potion)IWPotions.tinnitus) == null) {
                    this.field_147668_j = true;
                    playingTinnitus = null;
                }
            }

            public float func_147653_e() {
                return 0.5f;
            }

            public float func_147649_g() {
                return (float)mc.field_71439_g.field_70165_t;
            }

            public float func_147654_h() {
                return (float)mc.field_71439_g.field_70163_u;
            }

            public float func_147651_i() {
                return (float)mc.field_71439_g.field_70161_v;
            }

            public boolean func_147657_c() {
                return true;
            }
        };
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public void playJacobsLadderSound(TileEntityJacobsLadder te, int phase, Vec3d soundPos) {
        SoundEvent event;
        this.stopAllSoundsExcept(te.func_174877_v(), (Set<?>)ImmutableSet.of());
        switch (phase) {
            case 0: {
                event = IndustrialWires.LADDER_START;
                break;
            }
            case 1: {
                event = IndustrialWires.LADDER_MIDDLE;
                break;
            }
            case 2: {
                event = IndustrialWires.LADDER_END;
                break;
            }
            default: {
                return;
            }
        }
        PositionedSoundRecord sound = new PositionedSoundRecord(event.func_187503_a(), SoundCategory.BLOCKS, te.size.soundVolume, 1.0f, false, 0, ISound.AttenuationType.LINEAR, (float)soundPos.field_72450_a, (float)soundPos.field_72448_b, (float)soundPos.field_72449_c);
        ClientUtils.mc().func_147118_V().func_147682_a((ISound)sound);
        this.addSound(te.func_174877_v(), (ISound)sound);
    }

    @Override
    public void updateMechMBTurningSound(TileEntityMechMB te, MechEnergy energy) {
        IWTickableSound snd;
        Object soundsAtPos;
        SoundHandler sndHandler = ClientUtils.mc().func_147118_V();
        if (this.playingSounds.containsKey(te.func_174877_v())) {
            soundsAtPos = this.playingSounds.get(te.func_174877_v());
            soundsAtPos.removeIf(s -> !sndHandler.func_147692_c(s));
            if (soundsAtPos.isEmpty()) {
                this.playingSounds.remove(te.func_174877_v());
            }
        } else {
            soundsAtPos = ImmutableList.of();
        }
        boolean hasSlow = false;
        boolean hasFast = false;
        Iterator iterator = soundsAtPos.iterator();
        while (iterator.hasNext()) {
            ISound s2 = (ISound)iterator.next();
            if (s2.func_147650_b().equals((Object)IndustrialWires.TURN_FAST.func_187503_a())) {
                hasFast = true;
                continue;
            }
            if (!s2.func_147650_b().equals((Object)IndustrialWires.TURN_SLOW.func_187503_a())) continue;
            hasSlow = true;
        }
        if (!hasSlow && energy.getVolumeSlow() > 0.0f) {
            snd = new IWTickableSound(IndustrialWires.TURN_SLOW, SoundCategory.BLOCKS, energy::getVolumeSlow, energy::getPitch, te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p());
            sndHandler.func_147682_a((ISound)snd);
            this.addSound(te.func_174877_v(), (ISound)snd);
        }
        if (!hasFast && energy.getVolumeFast() > 0.0f) {
            snd = new IWTickableSound(IndustrialWires.TURN_FAST, SoundCategory.BLOCKS, energy::getVolumeFast, energy::getPitch, te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p());
            sndHandler.func_147682_a((ISound)snd);
            this.addSound(te.func_174877_v(), (ISound)snd);
        }
    }

    @Override
    public void playMarxBang(TileEntityMarx te, Vec3d pos, float energy) {
        SoundEvent soundLoc = IndustrialWires.MARX_BANG;
        if (energy < 0.0f) {
            energy = -energy;
            soundLoc = IndustrialWires.MARX_POP;
        }
        PositionedSoundRecord sound = new PositionedSoundRecord(soundLoc.func_187503_a(), SoundCategory.BLOCKS, 5.0f * energy, 1.0f, false, 0, ISound.AttenuationType.LINEAR, (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c);
        ClientUtils.mc().func_147118_V().func_147682_a((ISound)sound);
        this.addSound(te.func_174877_v(), (ISound)sound);
    }

    private void addSound(BlockPos pos, ISound sound) {
        List<ISound> allForPos = this.playingSounds.get(pos);
        if (allForPos == null) {
            allForPos = new ArrayList<ISound>();
        }
        allForPos.add(sound);
        if (allForPos.size() == 1) {
            this.playingSounds.put(pos, allForPos);
        }
    }

    @Override
    public void stopAllSoundsExcept(BlockPos pos, Set<?> excluded) {
        if (this.playingSounds.containsKey(pos)) {
            SoundHandler manager = Minecraft.func_71410_x().func_147118_V();
            List<ISound> sounds = this.playingSounds.get(pos);
            ArrayList<ISound> toRemove = new ArrayList<ISound>(sounds.size() - excluded.size());
            for (ISound sound : sounds) {
                if (excluded.contains(sound)) continue;
                manager.func_147683_b(sound);
                toRemove.add(sound);
            }
            sounds.removeAll(toRemove);
            if (sounds.isEmpty()) {
                this.playingSounds.remove(pos);
            }
        }
    }

    @Override
    public boolean isSingleplayer() {
        return Minecraft.func_71410_x().func_71356_B();
    }

    @Override
    public boolean isValidTextureSource(ItemStack stack) {
        if (!super.isValidTextureSource(stack)) {
            return false;
        }
        IBakedModel texModel = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null);
        TextureAtlasSprite sprite = texModel.func_177554_e();
        if (sprite == null || sprite.func_130098_m()) {
            return false;
        }
        int[][] data = sprite.func_147965_a(0);
        for (int x = 0; x < data.length; ++x) {
            for (int y = 0; y < data[x].length; ++y) {
                if (data[x][y] >>> 24 == 255) continue;
                return false;
            }
        }
        return true;
    }

    public Gui getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        EnumHand h;
        ItemStack held;
        if (ID == 0) {
            TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
            if (te instanceof TileEntityRSPanel) {
                return new GuiRSPanelConn((TileEntityRSPanel)te);
            }
            if (te instanceof TileEntityPanelCreator) {
                return new GuiPanelCreator(player.field_71071_by, (TileEntityPanelCreator)te);
            }
        } else if (ID == 1 && !(held = player.func_184586_b(h = z == 1 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND)).func_190926_b()) {
            if (held.func_77973_b() == IndustrialWires.panelComponent) {
                return new GuiPanelComponent(h, ItemPanelComponent.componentFromStack(held));
            }
            if (held.func_77973_b() == IndustrialWires.key) {
                return new GuiRenameKey(h);
            }
        }
        return null;
    }
}

