/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks;

import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxConnection;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyAdapter
implements IEnergyStorage {
    private IFluxReceiver rec;
    private IFluxProvider prov;
    private EnumFacing dir;

    public EnergyAdapter(IFluxConnection te, EnumFacing f) {
        this.dir = f;
        if (te instanceof IFluxReceiver) {
            this.rec = (IFluxReceiver)te;
        }
        if (te instanceof IFluxProvider) {
            this.prov = (IFluxProvider)te;
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.rec == null) {
            return 0;
        }
        return this.rec.receiveEnergy(this.dir, maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (this.prov == null) {
            return 0;
        }
        return this.prov.extractEnergy(this.dir, maxExtract, simulate);
    }

    public int getEnergyStored() {
        if (this.prov != null) {
            return this.prov.getEnergyStored(this.dir);
        }
        if (this.rec != null) {
            return this.rec.getEnergyStored(this.dir);
        }
        return 0;
    }

    public int getMaxEnergyStored() {
        if (this.prov != null) {
            return this.prov.getMaxEnergyStored(this.dir);
        }
        if (this.rec != null) {
            return this.rec.getMaxEnergyStored(this.dir);
        }
        return 0;
    }

    public boolean canExtract() {
        return this.prov != null;
    }

    public boolean canReceive() {
        return this.rec != null;
    }
}

