/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbguides.gui.components;

import com.feed_the_beast.ftbguides.gui.components.ComponentPanel;
import com.feed_the_beast.ftbguides.gui.components.GuideComponent;
import com.feed_the_beast.ftbguides.gui.components.IGuideComponentWidget;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.util.List;

public class ImageGuideComponent
extends GuideComponent {
    public final Icon image;
    public final int width;
    public final int height;

    public ImageGuideComponent(Icon i, int w, int h) {
        this.image = i;
        this.width = w;
        this.height = h;
    }

    public ImageGuideComponent(Icon i) {
        this(i, 16, 16);
    }

    @Override
    public String toString() {
        return this.image.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.image.isEmpty();
    }

    @Override
    public IGuideComponentWidget createWidget(ComponentPanel parent) {
        return new ImgWidget(parent, this);
    }

    public static class ImgWidget
    extends Widget
    implements IGuideComponentWidget {
        private final ImageGuideComponent component;

        public ImgWidget(ComponentPanel parent, ImageGuideComponent c) {
            super((Panel)parent);
            this.component = c;
            this.setWidth((int)((double)this.component.width / (double)this.getScreen().func_78325_e()));
            this.setHeight((int)((double)this.component.height / (double)this.getScreen().func_78325_e()));
            if (this.width > parent.maxWidth) {
                int w = Math.min(parent.maxWidth, this.width);
                double h = (double)this.height * ((double)w / (double)this.width);
                this.setWidth(w);
                this.setHeight(Math.max((int)h, 0));
            }
        }

        public void addMouseOverText(List<String> list) {
            String s = this.component.getProperty("hover", false);
            if (!s.isEmpty()) {
                list.add(s);
            }
        }

        public boolean mousePressed(MouseButton button) {
            String s;
            if (this.isMouseOver() && !(s = this.component.getProperty("click", true)).isEmpty() && this.handleClick(s)) {
                GuiHelper.playClickSound();
                return true;
            }
            return false;
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            this.component.image.draw(x, y, w, h);
        }
    }
}

