/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.blocks.decor;

import binnie.core.util.I18N;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class FenceType {
    @Nullable
    private static List<FenceType> VALUES;
    private final int size;
    private final boolean solid;
    private final boolean embossed;

    public FenceType(int size, boolean solid, boolean embedded) {
        this.size = size;
        this.solid = solid;
        this.embossed = embedded;
    }

    public FenceType(int meta) {
        this.size = meta & 3;
        this.solid = (meta >> 2 & 1) > 0;
        this.embossed = (meta >> 3 & 1) > 0;
    }

    public static Collection<FenceType> getValues() {
        if (VALUES == null) {
            VALUES = new ArrayList<FenceType>();
            for (int size = 0; size < 3; ++size) {
                for (boolean solid : new boolean[]{false, true}) {
                    for (boolean embedded : new boolean[]{false, true}) {
                        VALUES.add(new FenceType(size, solid, embedded));
                    }
                }
            }
        }
        return VALUES;
    }

    public String getPrefix() {
        String prefix = "";
        if (this.size == 1) {
            prefix = prefix + I18N.localise("extratrees.multifence.full.type");
        } else if (this.size == 2) {
            prefix = prefix + I18N.localise("extratrees.multifence.low.type");
        }
        if (this.solid) {
            if (!prefix.isEmpty()) {
                prefix = prefix + " ";
            }
            prefix = prefix + I18N.localise("extratrees.multifence.solid.type");
        }
        if (this.embossed) {
            if (!prefix.isEmpty()) {
                prefix = prefix + " ";
            }
            prefix = prefix + I18N.localise("extratrees.multifence.embedded.type");
        }
        if (!prefix.isEmpty()) {
            prefix = prefix + " ";
        }
        return prefix;
    }

    public int ordinal() {
        return this.size + ((this.solid ? 1 : 0) << 2) + ((this.embossed ? 1 : 0) << 3);
    }

    public boolean isPlain() {
        return this.size == 0 && !this.embossed && !this.solid;
    }

    public String toString() {
        return this.size + (this.embossed ? ":embossed" : "") + (this.solid ? ":solid" : "");
    }

    public boolean equals(Object obj) {
        if (obj instanceof FenceType) {
            FenceType o = (FenceType)obj;
            return o.size == this.size && o.embossed == this.embossed && o.solid == this.solid;
        }
        return super.equals(obj);
    }

    public int getSize() {
        return this.size;
    }

    public boolean isSolid() {
        return this.solid;
    }

    public boolean isEmbossed() {
        return this.embossed;
    }
}

