/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.utils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public final class CapabilityWrapper
implements ICapabilityProvider {
    private final ICapabilityProvider child;
    private final EnumFacing side;

    public CapabilityWrapper(ICapabilityProvider child, EnumFacing side) {
        this.child = child;
        this.side = side;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return (facing == null || facing == this.side) && this.child.hasCapability(capability, this.side);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(facing == null || facing == this.side ? this.child.getCapability(capability, this.side) : null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CapabilityWrapper)) {
            return false;
        }
        CapabilityWrapper that = (CapabilityWrapper)o;
        return this.child.equals(that.child) && this.side == that.side;
    }

    public int hashCode() {
        return 31 * this.child.hashCode() + this.side.hashCode();
    }
}

