/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.method;

import java.util.Objects;
import java.util.concurrent.Callable;

public final class MethodResult {
    private static final MethodResult empty = new MethodResult(null);
    private final Object[] result;
    private final Callable<MethodResult> next;
    private final Resolver resolver;
    private static final Resolver IMMEDIATE = () -> true;

    private MethodResult(Object[] result) {
        this.result = result;
        this.next = null;
        this.resolver = IMMEDIATE;
    }

    private MethodResult(Callable<MethodResult> next, Resolver resolver) {
        Objects.requireNonNull(next, "next cannot be null");
        Objects.requireNonNull(resolver, "resolver cannot be null");
        this.result = null;
        this.next = next;
        this.resolver = resolver;
    }

    public boolean isFinal() {
        return this.next == null;
    }

    public Object[] getResult() {
        if (!this.isFinal()) {
            throw new IllegalStateException("MethodResult is a callback");
        }
        return this.result;
    }

    public Callable<MethodResult> getCallback() {
        if (this.isFinal()) {
            throw new IllegalStateException("MethodResult is a result");
        }
        return this.next;
    }

    public Resolver getResolver() {
        if (this.isFinal()) {
            throw new IllegalStateException("MethodResult is a result");
        }
        return this.resolver;
    }

    public static MethodResult nextTick(Callable<MethodResult> next) {
        return new MethodResult(next, IMMEDIATE);
    }

    public static MethodResult nextTick(Runnable next) {
        return new MethodResult(MethodResult.wrap(next), IMMEDIATE);
    }

    public static MethodResult delayed(int delay, Callable<MethodResult> next) {
        return new MethodResult(next, delay <= 0 ? IMMEDIATE : new DelayedResolver(delay));
    }

    public static MethodResult delayed(int delay, Runnable next) {
        return new MethodResult(MethodResult.wrap(next), delay <= 0 ? IMMEDIATE : new DelayedResolver(delay));
    }

    public static MethodResult awaiting(Resolver resolver, Callable<MethodResult> next) {
        return new MethodResult(next, resolver);
    }

    public static MethodResult result(Object ... args) {
        return new MethodResult(args);
    }

    public static MethodResult result(Object arg) {
        return new MethodResult(new Object[]{arg});
    }

    public static MethodResult delayedResult(int delay, Object ... args) {
        return delay <= 0 ? new MethodResult(args) : new MethodResult(() -> MethodResult.result(args), new DelayedResolver(delay));
    }

    public static MethodResult failure(String message) {
        return new MethodResult(new Object[]{false, message});
    }

    public static MethodResult empty() {
        return empty;
    }

    private static Callable<MethodResult> wrap(Runnable runnable) {
        return () -> {
            runnable.run();
            return empty;
        };
    }

    private static class DelayedResolver
    implements Resolver {
        private int remaining;

        DelayedResolver(int remaining) {
            this.remaining = remaining;
        }

        @Override
        public boolean update() {
            return this.remaining-- == 0;
        }
    }

    @FunctionalInterface
    public static interface Resolver {
        public boolean update();
    }
}

