/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears.common;

import com.unascribed.ears.api.features.EarsFeatures;
import com.unascribed.ears.common.EarsImage;
import com.unascribed.ears.common.debug.EarsLog;
import com.unascribed.ears.common.util.BitInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class EarsFeaturesParserV1 {
    public static final int MAGIC = 15344897;

    public static EarsFeatures.Builder parse(EarsImage img) {
        ByteArrayOutputStream data = new ByteArrayOutputStream(45);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                if (x == 0 && y == 0) continue;
                int c = img.getARGB(x, 32 + y);
                data.write(c >> 16 & 0xFF);
                data.write(c >> 8 & 0xFF);
                data.write(c & 0xFF);
            }
        }
        return EarsFeaturesParserV1.parse(new ByteArrayInputStream(data.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EarsFeatures.Builder parse(InputStream in) {
        BitInputStream bis = null;
        try {
            int wingI;
            EarsFeatures.WingMode wingMode;
            EarsFeatures.EarAnchor earAnchor;
            EarsFeatures.EarMode earMode;
            bis = new BitInputStream(in);
            int ver = bis.read(8);
            EarsLog.debug(EarsLog.Tag.COMMON_FEATURES, "detect(...): Found v1.{} (Binary) data.", ver);
            int ears = bis.read(6);
            if (ears == 0) {
                earMode = EarsFeatures.EarMode.NONE;
                earAnchor = EarsFeatures.EarAnchor.CENTER;
            } else {
                earMode = EarsFeaturesParserV1.byOrdinalOr(EarsFeatures.EarMode.class, (ears - 1) / 3 + 1, EarsFeatures.EarMode.NONE);
                earAnchor = EarsFeaturesParserV1.byOrdinalOr(EarsFeatures.EarAnchor.class, (ears - 1) % 3, EarsFeatures.EarAnchor.CENTER);
            }
            EarsLog.debug(EarsLog.Tag.COMMON_FEATURES, "detect(...): Ears 6yte: {} (mode={} anchor={})", ears, (Object)earMode, (Object)earAnchor);
            boolean claws = bis.readBoolean();
            EarsLog.debug(EarsLog.Tag.COMMON_FEATURES, "detect(...): Claws bit: {}", claws);
            boolean horn = bis.readBoolean();
            EarsLog.debug(EarsLog.Tag.COMMON_FEATURES, "detect(...): Horn bit: {}", horn);
            int tailI = bis.read(3);
            EarsFeatures.TailMode tailMode = EarsFeaturesParserV1.byOrdinalOr(EarsFeatures.TailMode.class, tailI, EarsFeatures.TailMode.NONE);
            int tailSegments = 0;
            float tailBend0 = 0.0f;
            float tailBend1 = 0.0f;
            float tailBend2 = 0.0f;
            float tailBend3 = 0.0f;
            EarsLog.debug(EarsLog.Tag.COMMON_FEATURES, "detect(...): Tail 3yte: {} ({})", tailI, (Object)tailMode);
            if (tailMode != EarsFeatures.TailMode.NONE) {
                tailSegments = bis.read(2) + 1;
                EarsLog.debug(EarsLog.Tag.COMMON_FEATURES, "detect(...): Tail segments: {}", tailSegments);
                tailBend0 = bis.readSAMUnit(6) * 90.0f;
                tailBend1 = tailSegments > 1 ? bis.readSAMUnit(6) * 90.0f : 0.0f;
                tailBend2 = tailSegments > 2 ? bis.readSAMUnit(6) * 90.0f : 0.0f;
                tailBend3 = tailSegments > 3 ? bis.readSAMUnit(6) * 90.0f : 0.0f;
                EarsLog.debug(EarsLog.Tag.COMMON_FEATURES, "detect(...): Tail bends: {} {} {} {}", tailBend0, tailBend1, tailBend2, tailBend3);
            }
            int snoutOffset = 0;
            int snoutWidth = bis.read(3);
            int snoutHeight = 0;
            int snoutDepth = 0;
            if (snoutWidth > 0) {
                snoutHeight = bis.read(2) + 1;
                snoutDepth = bis.read(3) + 1;
                snoutOffset = bis.read(3);
                if (snoutOffset > 8 - snoutHeight) {
                    snoutOffset = 8 - snoutHeight;
                }
            }
            EarsLog.debug(EarsLog.Tag.COMMON_FEATURES, "detect(...): Snout: {}x{}x{}+0,{}", snoutWidth, (float)snoutHeight, (float)snoutDepth, (float)snoutOffset);
            float chestSize = bis.readUnit(5);
            if (chestSize > 0.0f) {
                EarsLog.debug(EarsLog.Tag.COMMON_FEATURES, "detect(...): Chest: {}%", (int)(chestSize * 100.0f));
            }
            boolean animateWings = (wingMode = EarsFeaturesParserV1.byOrdinalOr(EarsFeatures.WingMode.class, wingI = bis.read(3), EarsFeatures.WingMode.NONE)) == EarsFeatures.WingMode.NONE ? false : bis.readBoolean();
            EarsLog.debug(EarsLog.Tag.COMMON_FEATURES, "detect(...): Wing 3yte: {} (mode={} + animated={})", wingI, (Object)wingMode, animateWings);
            boolean capeEnabled = bis.readBoolean();
            EarsLog.debug(EarsLog.Tag.COMMON_FEATURES, "detect(...): Cape: {}", capeEnabled);
            boolean emissive = bis.readBoolean();
            EarsLog.debug(EarsLog.Tag.COMMON_FEATURES, "detect(...): Emissive: {}", emissive);
            EarsFeatures.Builder builder = EarsFeatures.builder().earMode(earMode).earAnchor(earAnchor).claws(claws).horn(horn).tailMode(tailMode).tailSegments(tailSegments).tailBends(tailBend0, tailBend1, tailBend2, tailBend3).snoutOffset(snoutOffset).snoutWidth(snoutWidth).snoutHeight(snoutHeight).snoutDepth(snoutDepth).chestSize(chestSize).wingMode(wingMode).animateWings(animateWings).capeEnabled(capeEnabled).emissive(emissive);
            return builder;
        }
        catch (IOException e) {
            EarsLog.debug(EarsLog.Tag.COMMON_FEATURES, "detect(...): Error while parsing v1 (Binary) data. Disabling", e);
            EarsFeatures.Builder builder = null;
            return builder;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static <E extends Enum<E>> E byOrdinalOr(Class<E> clazz, int ordinal, E def) {
        if (ordinal < 0) {
            return def;
        }
        Enum[] cnst = (Enum[])clazz.getEnumConstants();
        if (ordinal >= cnst.length) {
            return def;
        }
        return (E)cnst[ordinal];
    }
}

