/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears;

import com.unascribed.ears.Ears;
import com.unascribed.ears.api.features.EarsFeatures;
import com.unascribed.ears.common.EarsCommon;
import com.unascribed.ears.common.debug.EarsLog;
import com.unascribed.ears.common.render.DirectEarsRenderDelegate;
import com.unascribed.ears.common.render.EarsRenderDelegate;
import com.unascribed.ears.common.util.Decider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemElytra;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class LayerEars
implements LayerRenderer<AbstractClientPlayer> {
    private final RenderPlayer render;
    private final DirectEarsRenderDelegate<AbstractClientPlayer, ModelRenderer> delegate = new DirectEarsRenderDelegate<AbstractClientPlayer, ModelRenderer>(){

        @Override
        protected void setUpRenderState() {
            GlStateManager.func_179089_o();
            GlStateManager.func_179091_B();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
        }

        @Override
        protected void tearDownRenderState() {
            GlStateManager.func_179084_k();
            GlStateManager.func_179101_C();
            GlStateManager.func_179129_p();
        }

        @Override
        protected Decider<EarsRenderDelegate.BodyPart, ModelRenderer> decideModelPart(Decider<EarsRenderDelegate.BodyPart, ModelRenderer> d) {
            ModelPlayer model = LayerEars.this.render.func_177087_b();
            return d.map(EarsRenderDelegate.BodyPart.HEAD, model.field_78116_c).map(EarsRenderDelegate.BodyPart.LEFT_ARM, model.field_178724_i).map(EarsRenderDelegate.BodyPart.LEFT_LEG, model.field_178722_k).map(EarsRenderDelegate.BodyPart.RIGHT_ARM, model.field_178723_h).map(EarsRenderDelegate.BodyPart.RIGHT_LEG, model.field_178721_j).map(EarsRenderDelegate.BodyPart.TORSO, model.field_78115_e);
        }

        @Override
        protected void doAnchorTo(EarsRenderDelegate.BodyPart part, ModelRenderer modelPart) {
            if (((AbstractClientPlayer)this.peer).func_70093_af() && this.permittedBodyPart == null) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            modelPart.func_78794_c(0.0625f);
            ModelBox cuboid = (ModelBox)modelPart.field_78804_l.get(0);
            GlStateManager.func_179152_a((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179109_b((float)cuboid.field_78252_a, (float)cuboid.field_78249_e, (float)cuboid.field_78251_c);
        }

        @Override
        protected boolean isVisible(ModelRenderer modelPart) {
            return modelPart.field_78806_j;
        }

        @Override
        protected EarsFeatures getEarsFeatures() {
            return Ears.getEarsFeatures((AbstractClientPlayer)this.peer);
        }

        @Override
        public boolean isSlim() {
            return Ears.isSmallArms(LayerEars.this.render.func_177087_b());
        }

        @Override
        protected void pushMatrix() {
            GlStateManager.func_179094_E();
        }

        @Override
        protected void popMatrix() {
            GlStateManager.func_179121_F();
        }

        @Override
        protected void doBindSkin() {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(((AbstractClientPlayer)this.peer).func_110306_p());
        }

        @Override
        protected void doBindAux(EarsRenderDelegate.TexSource src, byte[] pngData) {
            if (pngData == null) {
                GlStateManager.func_179144_i((int)0);
            } else {
                ResourceLocation skin = ((AbstractClientPlayer)this.peer).func_110306_p();
                ResourceLocation id = new ResourceLocation(skin.func_110624_b(), src.addSuffix(skin.func_110623_a()));
                if (Minecraft.func_71410_x().func_110434_K().func_110581_b(id) == null) {
                    try {
                        Minecraft.func_71410_x().func_110434_K().func_110579_a(id, (ITextureObject)new DynamicTexture(ImageIO.read(new ByteArrayInputStream(pngData))));
                    }
                    catch (IOException e) {
                        Minecraft.func_71410_x().func_110434_K().func_110579_a(id, (ITextureObject)TextureUtil.field_111001_a);
                    }
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(id);
            }
        }

        @Override
        protected void doTranslate(float x, float y, float z) {
            GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        }

        @Override
        protected void doRotate(float ang, float x, float y, float z) {
            GlStateManager.func_179114_b((float)ang, (float)x, (float)y, (float)z);
        }

        @Override
        protected void doScale(float x, float y, float z) {
            GlStateManager.func_179152_a((float)x, (float)y, (float)z);
        }

        @Override
        protected void beginQuad() {
            Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181710_j);
        }

        @Override
        protected void addVertex(float x, float y, int z, float r, float g, float b, float a, float u, float v, float nX, float nY, float nZ) {
            Tessellator.func_178181_a().func_178180_c().func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)u, (double)v).func_181663_c(nX, nY, nZ).func_181675_d();
        }

        @Override
        protected void drawQuad() {
            Tessellator.func_178181_a().func_78381_a();
        }

        @Override
        public void setEmissive(boolean emissive) {
            super.setEmissive(emissive);
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            if (emissive) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179090_x();
            } else {
                GlStateManager.func_179145_e();
                GlStateManager.func_179098_w();
            }
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        }

        @Override
        protected void doRenderDebugDot(float r, float g, float b, float a) {
            GL11.glPointSize((float)8.0f);
            GlStateManager.func_179090_x();
            BufferBuilder bb = Tessellator.func_178181_a().func_178180_c();
            bb.func_181668_a(0, DefaultVertexFormats.field_181706_f);
            bb.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179098_w();
        }

        @Override
        public float getTime() {
            return (float)((AbstractClientPlayer)this.peer).field_70173_aa + Minecraft.func_71410_x().func_184121_ak();
        }

        @Override
        public boolean isFlying() {
            return ((AbstractClientPlayer)this.peer).field_71075_bZ.field_75100_b;
        }

        @Override
        public boolean isGliding() {
            return ((AbstractClientPlayer)this.peer).func_184613_cA();
        }

        @Override
        public boolean isJacketEnabled() {
            return ((AbstractClientPlayer)this.peer).func_175148_a(EnumPlayerModelParts.JACKET);
        }

        @Override
        public boolean isWearingBoots() {
            return ((AbstractClientPlayer)this.peer).func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemArmor;
        }

        @Override
        public boolean isWearingChestplate() {
            return ((AbstractClientPlayer)this.peer).func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemArmor;
        }

        @Override
        public boolean isWearingElytra() {
            return ((AbstractClientPlayer)this.peer).func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemElytra;
        }

        @Override
        public float getHorizontalSpeed() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_70141_P, ((AbstractClientPlayer)this.peer).field_70140_Q, Minecraft.func_71410_x().func_184121_ak());
        }

        @Override
        public float getLimbSwing() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_184618_aE, ((AbstractClientPlayer)this.peer).field_70721_aZ, Minecraft.func_71410_x().func_184121_ak());
        }

        @Override
        public float getStride() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_71107_bF, ((AbstractClientPlayer)this.peer).field_71109_bG, Minecraft.func_71410_x().func_184121_ak());
        }

        @Override
        public float getBodyYaw() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_70760_ar, ((AbstractClientPlayer)this.peer).field_70761_aq, Minecraft.func_71410_x().func_184121_ak());
        }

        @Override
        public double getCapeX() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_71091_bM, ((AbstractClientPlayer)this.peer).field_71094_bP, Minecraft.func_71410_x().func_184121_ak());
        }

        @Override
        public double getCapeY() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_71096_bN, ((AbstractClientPlayer)this.peer).field_71095_bQ, Minecraft.func_71410_x().func_184121_ak());
        }

        @Override
        public double getCapeZ() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_71097_bO, ((AbstractClientPlayer)this.peer).field_71085_bR, Minecraft.func_71410_x().func_184121_ak());
        }

        @Override
        public double getX() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_70169_q, ((AbstractClientPlayer)this.peer).field_70165_t, Minecraft.func_71410_x().func_184121_ak());
        }

        @Override
        public double getY() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_70167_r, ((AbstractClientPlayer)this.peer).field_70163_u, Minecraft.func_71410_x().func_184121_ak());
        }

        @Override
        public double getZ() {
            return EarsCommon.lerpDelta(((AbstractClientPlayer)this.peer).field_70166_s, ((AbstractClientPlayer)this.peer).field_70161_v, Minecraft.func_71410_x().func_184121_ak());
        }
    };

    public LayerEars(RenderPlayer render) {
        this.render = render;
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "Constructed");
    }

    public void doRenderLayer(AbstractClientPlayer entity, float limbAngle, float limbDistance, float tickDelta, float age, float headYaw, float headPitch, float scale) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "render({}, {}, {}, {}, {}, {}, {}, {}, {})", entity, limbAngle, limbDistance, tickDelta, age, headYaw, headPitch, scale);
        this.delegate.render(entity, null);
    }

    public void renderLeftArm(AbstractClientPlayer entity) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "renderLeftArm({})", entity);
        this.delegate.render(entity, EarsRenderDelegate.BodyPart.LEFT_ARM);
    }

    public void renderRightArm(AbstractClientPlayer entity) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "renderRightArm({})", entity);
        this.delegate.render(entity, EarsRenderDelegate.BodyPart.RIGHT_ARM);
    }

    public boolean func_177142_b() {
        return true;
    }
}

