/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears;

import com.unascribed.ears.LayerEars;
import com.unascribed.ears.api.features.EarsFeatures;
import com.unascribed.ears.common.EarsCommon;
import com.unascribed.ears.common.EarsFeaturesParser;
import com.unascribed.ears.common.EarsFeaturesStorage;
import com.unascribed.ears.common.debug.EarsLog;
import com.unascribed.ears.common.legacy.AWTEarsImage;
import com.unascribed.ears.common.util.EarsStorage;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.ImageBufferDownload;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod(modid="ears", name="Ears", version="1.4.7", useMetadata=true, clientSideOnly=true, acceptedMinecraftVersions="(1.9,1.12.99)", guiFactory="com.unascribed.ears.EarsGuiFactory")
public class Ears {
    public static final Map<ITextureObject, EarsFeatures> earsSkinFeatures = new WeakHashMap<ITextureObject, EarsFeatures>();
    private static final Map<RenderPlayer, LayerEars> earsLayers = new WeakHashMap<RenderPlayer, LayerEars>();
    private static boolean reentering;
    private static final MethodHandle setAreaOpaque;
    private static final MethodHandle imageHeight;
    private static final MethodHandle smallArms;

    public Ears() {
        if (EarsLog.DEBUG) {
            EarsLog.debugva(EarsLog.Tag.PLATFORM, "Initialized - {} / Forge {}; Side={}", Loader.instance().getMCVersionString(), ForgeVersion.getVersion(), FMLCommonHandler.instance().getSide());
        }
    }

    public static void preprocessSkin(ImageBufferDownload subject, BufferedImage rawImg, BufferedImage img) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_INJECT, "preprocessSkin({}, {}, {})", (Object)subject, (Object)rawImg, (Object)img);
        EarsStorage.put(img, EarsStorage.Key.ALFALFA, EarsCommon.preprocessSkin(new AWTEarsImage(rawImg)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean interceptSetAreaOpaque(ImageBufferDownload subject, int x1, int y1, int x2, int y2) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_INJECT, "stripAlpha({}, {}, {}, {}, {}, {}) reentering={}", (Object)subject, x1, y2, x2, y2, reentering);
        if (reentering) {
            return true;
        }
        if (x1 == 0 && y1 == 0 && x2 == 32 && y2 == 16) {
            try {
                reentering = true;
                EarsCommon.carefullyStripAlpha((_x1, _y1, _x2, _y2) -> Ears.setAreaOpaque(subject, _x1, _y1, _x2, _y2), Ears.getImageHeight(subject) != 32);
            }
            finally {
                reentering = false;
            }
        }
        return false;
    }

    public static boolean shouldSuppressElytra(EntityLivingBase entity) {
        return entity instanceof AbstractClientPlayer && EarsCommon.shouldSuppressElytra(Ears.getEarsFeatures((AbstractClientPlayer)entity));
    }

    public static void checkSkin(ThreadDownloadImageData tdid, BufferedImage img) {
        if (img == null) {
            return;
        }
        EarsLog.debug(EarsLog.Tag.PLATFORM_INJECT, "Process player skin");
        earsSkinFeatures.put((ITextureObject)tdid, EarsFeaturesParser.detect(new AWTEarsImage(img), EarsStorage.get(img, EarsStorage.Key.ALFALFA), data -> new AWTEarsImage(ImageIO.read(new ByteArrayInputStream(data)))));
    }

    public static void addLayer(RenderPlayer rp) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_INJECT, "Construct player renderer");
        LayerEars layer = new LayerEars(rp);
        earsLayers.put(rp, layer);
        rp.func_177094_a((LayerRenderer)layer);
    }

    public static void renderLeftArm(RenderPlayer rp, AbstractClientPlayer player) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "renderLeftArm({}, {})", (Object)rp, (Object)player);
        LayerEars le = earsLayers.get(rp);
        if (le != null) {
            le.renderLeftArm(player);
        }
    }

    public static void renderRightArm(RenderPlayer rp, AbstractClientPlayer player) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "renderRightArm({}, {})", (Object)rp, (Object)player);
        LayerEars le = earsLayers.get(rp);
        if (le != null) {
            le.renderRightArm(player);
        }
    }

    private static int getImageHeight(ImageBufferDownload subject) {
        try {
            return imageHeight.invokeExact(subject);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void setAreaOpaque(ImageBufferDownload subject, int x1, int y1, int x2, int y2) {
        try {
            setAreaOpaque.invokeExact(subject, x1, y1, x2, y2);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static boolean isSmallArms(ModelPlayer subject) {
        try {
            return smallArms.invokeExact(subject);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static EarsFeatures getEarsFeatures(AbstractClientPlayer peer) {
        ResourceLocation skin = peer.func_110306_p();
        ITextureObject tex = Minecraft.func_71410_x().func_110434_K().func_110581_b(skin);
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "getEarsFeatures(): skin={}, tex={}", (Object)skin, (Object)tex);
        if (earsSkinFeatures.containsKey(tex)) {
            EarsFeatures feat = earsSkinFeatures.get(tex);
            EarsFeaturesStorage.INSTANCE.put(peer.func_146103_bH().getName(), peer.func_146103_bH().getId(), feat);
            if (!peer.func_82150_aj()) {
                return feat;
            }
        }
        return EarsFeatures.DISABLED;
    }

    static {
        try {
            Method jlr = ObfuscationReflectionHelper.findMethod(ImageBufferDownload.class, (String)"func_78433_b", Void.TYPE, (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
            jlr.setAccessible(true);
            setAreaOpaque = MethodHandles.lookup().unreflect(jlr);
            Field ihf = ObfuscationReflectionHelper.findField(ImageBufferDownload.class, (String)"field_78437_c");
            ihf.setAccessible(true);
            imageHeight = MethodHandles.lookup().unreflectGetter(ihf);
            Field sa = ObfuscationReflectionHelper.findField(ModelPlayer.class, (String)"field_178735_y");
            sa.setAccessible(true);
            smallArms = MethodHandles.lookup().unreflectGetter(sa);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }
}

