/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.extruder;

import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiExtruder;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.machine.BaseRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.extruder.ExtruderRecipeCategorySedimentary;
import cofh.thermalexpansion.plugins.jei.machine.extruder.ExtruderRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.ExtruderManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ExtruderRecipeCategory
extends BaseRecipeCategory<ExtruderRecipeWrapper> {
    public static boolean enable = true;
    protected IDrawableStatic progress;
    protected IDrawableStatic speed;
    protected IDrawableStatic slot;
    protected IDrawableStatic tankHotOverlay;
    protected IDrawableStatic tankColdOverlay;

    public static void register(IRecipeCategoryRegistration registry) {
        String category = "Plugins.JEI";
        if (!(enable = ThermalExpansion.CONFIG_CLIENT.get(category, "Machine.Extruder", enable))) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new ExtruderRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ExtruderRecipeCategorySedimentary(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        try {
            IJeiHelpers jeiHelpers = registry.getJeiHelpers();
            IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
            registry.addRecipes(ExtruderRecipeCategory.getRecipes(guiHelper), "thermalexpansion.extruder");
            registry.addRecipeClickArea(GuiExtruder.class, 85, 26, 24, 16, new String[]{"thermalexpansion.extruder", "thermalexpansion.extruder_sedimentary"});
            registry.addRecipeCatalyst((Object)BlockMachine.machineExtruder, new String[]{"thermalexpansion.extruder"});
            ExtruderRecipeCategorySedimentary.initialize(registry);
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Bad/null recipe!", t);
        }
    }

    public static List<ExtruderRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<ExtruderRecipeWrapper> recipes = new ArrayList<ExtruderRecipeWrapper>();
        for (ExtruderManager.ExtruderRecipe recipe : ExtruderManager.getRecipeList(false)) {
            recipes.add(new ExtruderRecipeWrapper(guiHelper, recipe));
        }
        return recipes;
    }

    public ExtruderRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiExtruder.TEXTURE, 26, 11, 52, 40, 0, 22, 16, 96);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.extruder.name");
        this.progress = Drawables.getDrawables(guiHelper).getProgress(2);
        this.speed = Drawables.getDrawables(guiHelper).getScale(2);
        this.slot = Drawables.getDrawables(guiHelper).getSlot(1);
        this.tankHotOverlay = Drawables.getDrawables(guiHelper).getTankSmallOverlay(2);
        this.tankColdOverlay = Drawables.getDrawables(guiHelper).getTankSmallOverlay(2);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.extruder";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 34, 40);
        this.slot.draw(minecraft, 101, 19);
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, ExtruderRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputFluids = ingredients.getInputs(FluidStack.class);
        List outputItems = ingredients.getOutputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, false, 105, 23);
        guiFluidStacks.init(0, true, 22, 8, 16, 30, 4000, false, (IDrawable)this.tankHotOverlay);
        guiFluidStacks.init(1, true, 46, 8, 16, 30, 4000, false, (IDrawable)this.tankColdOverlay);
        guiItemStacks.set(0, (List)outputItems.get(0));
        guiFluidStacks.set(0, (List)inputFluids.get(0));
        guiFluidStacks.set(1, (List)inputFluids.get(1));
    }
}

