/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.common.internal.mixins;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import zone.rong.loliasm.LoliLogger;
import zone.rong.loliasm.api.ICapabilityDispatcherManipulator;

@Mixin(value={CapabilityDispatcher.class}, remap=false)
public class CapabilityDispatcherMixin
implements ICapabilityDispatcherManipulator {
    @Shadow
    private ICapabilityProvider[] caps;
    @Shadow
    private INBTSerializable<NBTBase>[] writers;
    @Shadow
    private String[] names;

    @Override
    public void injectCapability(String name, ICapabilityProvider provider) {
        this.caps = (ICapabilityProvider[])ArrayUtils.add((Object[])this.caps, (Object)provider);
        if (provider instanceof INBTSerializable) {
            this.writers = (INBTSerializable[])ArrayUtils.add((Object[])this.writers, (Object)((INBTSerializable)provider));
            this.names = (String[])ArrayUtils.add((Object[])this.names, (Object)name);
        }
    }

    @Override
    public <T> void stripCapability(String name, Capability<T> capability, @Nullable EnumFacing facing, T capabilityInstance) {
        ICapabilityProvider provider = null;
        for (ICapabilityProvider p : this.caps) {
            if (p.getCapability(capability, facing) != capabilityInstance) continue;
            provider = p;
        }
        if (provider == null) {
            LoliLogger.instance.error("{}@{} does not exist in {}", (Object)name, (Object)capability.getName(), (Object)Arrays.toString(this.caps));
            return;
        }
        this.caps = (ICapabilityProvider[])ArrayUtils.removeElement((Object[])this.caps, provider);
        if (provider instanceof INBTSerializable) {
            this.writers = (INBTSerializable[])ArrayUtils.removeElement((Object[])this.writers, (Object)provider);
            this.names = (String[])ArrayUtils.removeElement((Object[])this.names, (Object)name);
        }
    }
}

