/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.api;

import it.unimi.dsi.fastutil.Hash;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.item.ItemStack;

public class HashingStrategies {
    public static final Hash.Strategy<Object> IDENTITY_OBJECT_HASH = new Hash.Strategy<Object>(){

        public int hashCode(Object o) {
            return System.identityHashCode(o);
        }

        public boolean equals(Object a, Object b) {
            return a == b;
        }
    };
    public static final Hash.Strategy<Object> GENERIC_OBJECT_HASH = new Hash.Strategy<Object>(){

        public int hashCode(Object o) {
            return Objects.hashCode(o);
        }

        public boolean equals(Object o1, Object o2) {
            return Objects.equals(o1, o2);
        }
    };
    public static final Hash.Strategy<float[][]> FLOAT_2D_ARRAY_HASH = new Hash.Strategy<float[][]>(){

        public int hashCode(float[][] o) {
            return Arrays.deepHashCode((Object[])o);
        }

        public boolean equals(float[][] a, float[][] b) {
            return Arrays.deepEquals((Object[])a, (Object[])b);
        }
    };
    public static final Hash.Strategy<ItemCameraTransforms> ITEM_CAMERA_TRANSFORMS_HASH = new Hash.Strategy<ItemCameraTransforms>(){

        public int hashCode(ItemCameraTransforms ict) {
            int hash = HashingStrategies.vectorHash(ict.field_188038_m);
            hash = hash * 31 + HashingStrategies.vectorHash(ict.field_188039_n);
            hash = hash * 31 + HashingStrategies.vectorHash(ict.field_181700_p);
            hash = hash * 31 + HashingStrategies.vectorHash(ict.field_181699_o);
            hash = hash * 31 + HashingStrategies.vectorHash(ict.field_178354_e);
            hash = hash * 31 + HashingStrategies.vectorHash(ict.field_178353_d);
            hash = hash * 31 + HashingStrategies.vectorHash(ict.field_188036_k);
            return hash * 31 + HashingStrategies.vectorHash(ict.field_188037_l);
        }

        public boolean equals(ItemCameraTransforms ict1, ItemCameraTransforms ict2) {
            if (ict1 == null) {
                return ict2 == null;
            }
            return Objects.equals(ict1.field_188038_m, ict2.field_188038_m) && Objects.equals(ict1.field_188039_n, ict2.field_188039_n) && Objects.equals(ict1.field_181700_p, ict2.field_181700_p) && Objects.equals(ict1.field_181699_o, ict2.field_181699_o) && Objects.equals(ict1.field_178354_e, ict2.field_178354_e) && Objects.equals(ict1.field_178353_d, ict2.field_178353_d) && Objects.equals(ict1.field_188036_k, ict2.field_188036_k) && Objects.equals(ict1.field_188037_l, ict2.field_188037_l);
        }
    };
    public static final Hash.Strategy<ItemStack> FURNACE_INPUT_HASH = new Hash.Strategy<ItemStack>(){

        public int hashCode(ItemStack o) {
            return 31 * o.func_77973_b().hashCode();
        }

        public boolean equals(ItemStack a, ItemStack b) {
            if (a == null || b == null) {
                return false;
            }
            return a.func_77973_b() == b.func_77973_b() && (a.func_77960_j() == b.func_77960_j() || b.func_77960_j() == Short.MAX_VALUE);
        }
    };

    private static int vectorHash(ItemTransformVec3f vector) {
        int hash = (Float.floatToIntBits(vector.field_178364_b.getX()) * 31 + Float.floatToIntBits(vector.field_178364_b.getY())) * 31 + Float.floatToIntBits(vector.field_178364_b.getZ());
        hash = hash * 31 + (Float.floatToIntBits(vector.field_178363_d.getX()) * 31 + Float.floatToIntBits(vector.field_178363_d.getY())) * 31 + Float.floatToIntBits(vector.field_178363_d.getZ());
        return hash * 31 + (Float.floatToIntBits(vector.field_178365_c.getX()) * 31 + Float.floatToIntBits(vector.field_178365_c.getY())) * 31 + Float.floatToIntBits(vector.field_178365_c.getZ());
    }
}

