/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer.gui.swing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.installer.Localization;
import org.quiltmc.installer.OsPaths;
import org.quiltmc.installer.VersionManifest;
import org.quiltmc.installer.action.Action;
import org.quiltmc.installer.action.InstallClient;
import org.quiltmc.installer.gui.swing.AbstractPanel;
import org.quiltmc.installer.gui.swing.SwingInstaller;

final class ClientPanel
extends AbstractPanel
implements Consumer<InstallClient.MessageType> {
    private final JComboBox<String> minecraftVersionSelector;
    private final JComboBox<String> loaderVersionSelector;
    private final JCheckBox showSnapshotsCheckBox;
    private final JTextField installLocation;
    private final JButton selectInstallationLocation;
    private final JButton installButton;
    private boolean showSnapshots;
    private boolean generateProfile;

    ClientPanel(SwingInstaller gui) {
        super(gui);
        JComponent row1 = this.addRow();
        row1.add(new JLabel(Localization.get("gui.game.version")));
        this.minecraftVersionSelector = new JComboBox();
        row1.add(this.minecraftVersionSelector);
        this.minecraftVersionSelector.setPreferredSize(new Dimension(170, 26));
        this.minecraftVersionSelector.addItem(Localization.get("gui.install.loading"));
        this.minecraftVersionSelector.setEnabled(false);
        this.showSnapshotsCheckBox = new JCheckBox(Localization.get("gui.game.version.snapshots"));
        row1.add(this.showSnapshotsCheckBox);
        this.showSnapshotsCheckBox.setEnabled(false);
        this.showSnapshotsCheckBox.addItemListener(e -> {
            if (this.manifest() != null) {
                this.showSnapshots = e.getStateChange() == 1;
                ClientPanel.populateMinecraftVersions(this.minecraftVersionSelector, this.manifest(), this.intermediaryVersions(), this.showSnapshots);
            }
        });
        JComponent row2 = this.addRow();
        row2.add(new JLabel(Localization.get("gui.loader.version")));
        this.loaderVersionSelector = new JComboBox();
        row2.add(this.loaderVersionSelector);
        this.loaderVersionSelector.setPreferredSize(new Dimension(200, 26));
        this.loaderVersionSelector.addItem(Localization.get("gui.install.loading"));
        this.loaderVersionSelector.setEnabled(false);
        JComponent row3 = this.addRow();
        row3.add(new JLabel(Localization.get("gui.install-location")));
        this.installLocation = new JTextField();
        row3.add(this.installLocation);
        this.installLocation.setPreferredSize(new Dimension(300, 26));
        this.installLocation.setText(OsPaths.getDefaultInstallationDir().toString());
        this.selectInstallationLocation = new JButton();
        row3.add(this.selectInstallationLocation);
        this.selectInstallationLocation.setText("...");
        this.selectInstallationLocation.addActionListener(e -> {
            @Nullable String newLocation = ClientPanel.displayFileChooser(this.installLocation.getText());
            if (newLocation != null) {
                this.installLocation.setText(newLocation);
            }
        });
        JComponent row4 = this.addRow();
        JCheckBox generateProfile = new JCheckBox(Localization.get("gui.client.generate-profile"), null, true);
        row4.add(generateProfile);
        generateProfile.addItemListener(e -> {
            this.generateProfile = e.getStateChange() == 1;
        });
        this.generateProfile = true;
        JComponent row5 = this.addRow();
        this.installButton = new JButton();
        row5.add(this.installButton);
        this.installButton.setEnabled(false);
        this.installButton.setText(Localization.get("gui.install.loading"));
        this.installButton.addActionListener(this::install);
    }

    private void install(ActionEvent event) {
        InstallClient action = Action.installClient((String)this.minecraftVersionSelector.getSelectedItem(), (String)this.loaderVersionSelector.getSelectedItem(), this.installLocation.getText(), this.generateProfile);
        ((Action)action).run(this);
        ClientPanel.showInstalledMessage();
    }

    @Override
    void receiveVersions(VersionManifest manifest, List<String> loaderVersions, Collection<String> intermediaryVersions) {
        super.receiveVersions(manifest, loaderVersions, intermediaryVersions);
        ClientPanel.populateMinecraftVersions(this.minecraftVersionSelector, manifest, intermediaryVersions, this.showSnapshots);
        this.showSnapshotsCheckBox.setEnabled(true);
        ClientPanel.populateLoaderVersions(this.loaderVersionSelector, loaderVersions);
        this.installButton.setText(Localization.get("gui.install"));
        this.installButton.setEnabled(true);
    }

    @Override
    public void accept(InstallClient.MessageType messageType) {
    }
}

